/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk;

import org.dashj.platform.sdk.BaseTest;
import org.dashj.platform.sdk.BinaryData;
import org.dashj.platform.sdk.dashsdk;
import org.junit.Assert;
import org.junit.Test;

public class BinaryDataTest
extends BaseTest {
    @Test
    public void binaryDataTest() {
        BinaryData data = new BinaryData(identifier);
        Assert.assertTrue((boolean)data.swigCMemOwn);
        Assert.assertEquals((long)32L, (long)data.get_0().length);
        Assert.assertArrayEquals((byte[])identifier, (byte[])data.get_0());
        data.delete();
    }

    @Test
    public void createBinaryDataInJavaAndDestroyTest() {
        System.out.println("Java-------");
        BinaryData data = new BinaryData(identifier);
        Assert.assertEquals((long)32L, (long)data.get_0().length);
        Assert.assertArrayEquals((byte[])identifier, (byte[])data.get_0());
        System.out.printf("BinaryData %x\n", BinaryData.getCPtr((BinaryData)data));
        data.delete();
    }

    @Test
    public void getBinaryDataEmptyTest() {
        BinaryData data = dashsdk.platformMobileTestsGetBinaryDataEmpty();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)0L, (long)data.get_0().length);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])data.get_0());
        data.delete();
    }

    @Test
    public void getBinaryData4Test() {
        BinaryData data = dashsdk.platformMobileTestsGetBinaryData4();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)4L, (long)data.get_0().length);
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])data.get_0());
        data.delete();
    }
}

