/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bitcoinj.core.Base58;
import org.dashj.platform.sdk.Document;
import org.dashj.platform.sdk.DocumentV0;
import org.dashj.platform.sdk.Hash256;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.OrderClause;
import org.dashj.platform.sdk.PlatformValue;
import org.dashj.platform.sdk.Revision;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.SdkBaseTest;
import org.dashj.platform.sdk.Start;
import org.dashj.platform.sdk.WhereClause;
import org.dashj.platform.sdk.WhereOperator;
import org.dashj.platform.sdk.base.Result;
import org.dashj.platform.sdk.dashsdk;
import org.junit.Assert;
import org.junit.Test;

public class DocumentTest
extends SdkBaseTest {
    @Test
    public void getDocumentsTest() throws Exception {
        Identifier domainId = new Identifier(dpnsContractId);
        Result docs = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)new Identifier(dpnsContractId), (String)"domain", new ArrayList(), new ArrayList(), (long)100L, null);
        Assert.assertFalse((boolean)((List)docs.unwrap()).isEmpty());
    }

    @Test
    public void documentListTest() {
    }

    @Test
    public void getDocumentWithIDTest() throws Exception {
        Identifier dpnsContractIdentifier = new Identifier(dpnsContractId);
        Result all = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)dpnsContractIdentifier, (String)"domain", new ArrayList(), new ArrayList(), (long)100L, null);
        Identifier id = null;
        for (Document d : (List)all.unwrap()) {
            PlatformValue value = (PlatformValue)((PlatformValue)d.getV0().get_0().getProperties().get("records")).getMap().get_0().get(new PlatformValue("identity"));
            if (value == null) continue;
            id = new Identifier(value.getIdentifier().getBytes());
            break;
        }
        Assert.assertNotNull(id);
        ArrayList<WhereClause> where = new ArrayList<WhereClause>();
        where.add(new WhereClause("$id", WhereOperator.Equal, new PlatformValue(new Hash256(id.getBytes()))));
        Result result = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)new Identifier(dpnsContractId), (String)"domain", where, new ArrayList(), (long)100L, null);
        Assert.assertFalse((boolean)((List)result.unwrap()).isEmpty());
    }

    @Test
    public void getDocumentStartsWithTest() throws Exception {
        ArrayList<WhereClause> where = new ArrayList<WhereClause>();
        where.add(new WhereClause("normalizedLabel", WhereOperator.StartsWith, new PlatformValue("test")));
        ArrayList<OrderClause> order = new ArrayList<OrderClause>();
        order.add(new OrderClause("normalizedLabel", true));
        Result result = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)new Identifier(dpnsContractId), (String)"domain", where, order, (long)100L, null);
        List docs = (List)result.unwrap();
        Assert.assertFalse((boolean)docs.isEmpty());
        docs.forEach(document -> {
            Map props = document.getV0().get_0().getProperties();
            System.out.println(((PlatformValue)props.get("label")).getText());
        });
    }

    @Test
    public void createDocumentTest() {
        Identifier docId = new Identifier(identifier);
        Identifier ownerId = new Identifier(identifier);
        Revision revision = new Revision(2);
        HashMap<String, PlatformValue> map = new HashMap<String, PlatformValue>();
        map.put("text", new PlatformValue("value"));
        DocumentV0 documentV0 = new DocumentV0(docId, ownerId, map, revision);
        Document document = new Document(documentV0);
        Assert.assertEquals((Object)Document.Tag.V0, (Object)document.getTag());
        DocumentV0 docv0 = document.getV0().get_0();
        Assert.assertEquals((Object)docId, (Object)docv0.getId());
        Assert.assertEquals((Object)ownerId, (Object)docv0.getOwner_id());
        Assert.assertEquals((Object)new Revision(2), (Object)docv0.getRevision());
        Map properties = docv0.getProperties();
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)"text", properties.keySet().stream().findFirst().get());
        Assert.assertEquals((Object)"value", (Object)((PlatformValue)properties.values().stream().findFirst().get()).getText());
        document.delete();
        document.delete();
        docId.delete();
        ownerId.delete();
    }

    @Test
    public void queryTest() {
        try {
            Identifier dpnsId = new Identifier(dpnsContractId);
            ArrayList<WhereClause> where = new ArrayList<WhereClause>();
            ArrayList<OrderClause> orderBy = new ArrayList<OrderClause>();
            Result docsResult = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)dpnsId, (String)"domain", where, orderBy, (long)5L, null);
            ((List)docsResult.unwrap()).forEach(document -> {
                Map props = document.getV0().get_0().getProperties();
                System.out.println(((PlatformValue)props.get("label")).getText());
            });
            where.add(new WhereClause("normalizedLabel", WhereOperator.StartsWith, new PlatformValue("test")));
            where.add(new WhereClause("normalizedParentDomainName", WhereOperator.Equal, new PlatformValue("dash")));
            orderBy.add(new OrderClause("normalizedLabel"));
            Result docs2 = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)dpnsId, (String)"domain", where, orderBy, (long)100L, null);
            System.out.println("------ query ------");
            ((List)docs2.unwrap()).forEach(document -> {
                Map props = document.getV0().get_0().getProperties();
                System.out.println(((PlatformValue)props.get("label")).getText());
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void queryTestFail() {
        try {
            Identifier dpnsId = new Identifier(dpnsContractId);
            ArrayList<WhereClause> where = new ArrayList<WhereClause>();
            ArrayList<OrderClause> orderBy = new ArrayList<OrderClause>();
            Result docsResult = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)dpnsId, (String)"domain", where, orderBy, (long)5L, null);
            ((List)docsResult.unwrap()).forEach(document -> {
                Map props = document.getV0().get_0().getProperties();
                System.out.println(((PlatformValue)props.get("label")).getText());
            });
            where.add(new WhereClause("normalizedLabel", WhereOperator.StartsWith, new PlatformValue("zys-aaa")));
            where.add(new WhereClause("normalizedParentDomainName", WhereOperator.Equal, new PlatformValue("dash")));
            orderBy.add(new OrderClause("normalizedLabel"));
            Result docs2 = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)dpnsId, (String)"domain", where, orderBy, (long)100L, null);
            System.out.println("------ query ------");
            ((List)docs2.unwrap()).forEach(document -> {
                Map props = document.getV0().get_0().getProperties();
                System.out.println(((PlatformValue)props.get("label")).getText());
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void queryAllTest() {
        try {
            Identifier dpnsId = new Identifier(dpnsContractId);
            ArrayList<WhereClause> where = new ArrayList<WhereClause>();
            ArrayList<OrderClause> orderBy = new ArrayList<OrderClause>();
            where.add(new WhereClause("normalizedParentDomainName", WhereOperator.Equal, new PlatformValue("dash")));
            orderBy.add(new OrderClause("normalizedLabel"));
            int count = 0;
            Start startAfter = null;
            do {
                Result result = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)dpnsId, (String)"domain", where, orderBy, (long)100L, startAfter);
                List docs = (List)result.unwrap();
                System.out.println("------ query ------");
                System.out.println("items: " + docs.size());
                docs.forEach(document -> {
                    Map props = document.getV0().get_0().getProperties();
                    System.out.println(((PlatformValue)props.get("label")).getText());
                    System.out.println("  id:     :  " + Base58.encode((byte[])document.getV0().get_0().getId().getBytes()));
                    System.out.println("  identity:  " + Base58.encode((byte[])((PlatformValue)((PlatformValue)props.get("records")).getMap().get_0().get(new PlatformValue("identity"))).getIdentifier().getBytes()));
                });
                count = docs.size();
                if (count <= 0) continue;
                startAfter = new Start(((Document)docs.get(docs.size() - 1)).getV0().get_0().getId().getBytes(), true);
                System.out.println("start after: " + Base58.encode((byte[])startAfter.getStart_after().get_0()));
            } while (count == 100);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void startsWithQueryTest() {
        try {
            Identifier dpnsId = new Identifier(dpnsContractId);
            ArrayList<WhereClause> where = new ArrayList<WhereClause>();
            ArrayList<OrderClause> orderBy = new ArrayList<OrderClause>();
            where.add(new WhereClause("normalizedLabel", WhereOperator.StartsWith, new PlatformValue("tut")));
            where.add(new WhereClause("normalizedParentDomainName", WhereOperator.Equal, new PlatformValue("dash")));
            orderBy.add(new OrderClause("normalizedLabel"));
            Result docs2 = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)dpnsId, (String)"domain", where, orderBy, (long)100L, null);
            List documents = (List)docs2.unwrap();
            Assert.assertFalse((boolean)documents.isEmpty());
            documents.forEach(document -> {
                Map props = document.getV0().get_0().getProperties();
                System.out.println(((PlatformValue)props.get("label")).getText());
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void startsWithQueryWithSDKTest() {
        try {
            Identifier dpnsId = new Identifier(dpnsContractId);
            ArrayList<WhereClause> where = new ArrayList<WhereClause>();
            ArrayList<OrderClause> orderBy = new ArrayList<OrderClause>();
            where.add(new WhereClause("normalizedLabel", WhereOperator.StartsWith, new PlatformValue("tut")));
            where.add(new WhereClause("normalizedParentDomainName", WhereOperator.Equal, new PlatformValue("dash")));
            orderBy.add(new OrderClause("normalizedLabel"));
            Result docs2 = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)dpnsId, (String)"domain", where, orderBy, (long)100L, null);
            List documents = (List)docs2.unwrap();
            Assert.assertFalse((boolean)documents.isEmpty());
            documents.forEach(document -> {
                Map props = document.getV0().get_0().getProperties();
                System.out.println(((PlatformValue)props.get("label")).getText());
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void createSDKTest() throws Exception {
        ArrayList list = new ArrayList();
        ArrayList list2 = new ArrayList();
        Result result = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)new Identifier(dpnsContractId), (String)"domain", list, list2, (long)100L, null);
        List documentList = (List)result.unwrap();
        documentList.forEach(doc -> System.out.println(doc.getV0().get_0().getId().getBytes().length));
    }
}

