/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.dashj.platform.sdk.AssetLockProof;
import org.dashj.platform.sdk.BaseTest;
import org.dashj.platform.sdk.BinaryData;
import org.dashj.platform.sdk.ChainAssetLockProof;
import org.dashj.platform.sdk.ContractBounds;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.Identity;
import org.dashj.platform.sdk.IdentityPublicKey;
import org.dashj.platform.sdk.IdentityPublicKeyV0;
import org.dashj.platform.sdk.IdentityV0;
import org.dashj.platform.sdk.InstantAssetLockProof;
import org.dashj.platform.sdk.KeyID;
import org.dashj.platform.sdk.KeyType;
import org.dashj.platform.sdk.OutPoint;
import org.dashj.platform.sdk.Purpose;
import org.dashj.platform.sdk.Revision;
import org.dashj.platform.sdk.SecurityLevel;
import org.dashj.platform.sdk.TimestampMillis;
import org.dashj.platform.sdk.dashsdk;
import org.junit.Assert;
import org.junit.Test;

public class IdentityObjectTest
extends BaseTest {
    private static final String testIdentifier = "7Yowk46VwwHqmD5yZyyygggh937aP6h2UW7aQWBdWpM5";

    @Test
    public void basicIdentityInRustAndDestroy() {
        Identifier identifier1 = new Identifier(identifier);
        Identity identity = dashsdk.createBasicIdentity((byte[])identifier);
        Assert.assertEquals((Object)Identity.Tag.V0, (Object)identity.getTag());
        IdentityV0 identityV0 = identity.getV0().get_0();
        Assert.assertNotNull((Object)identityV0);
        Assert.assertArrayEquals((byte[])identifier, (byte[])identityV0.getId().get_0().get_0());
        Assert.assertEquals((long)0L, (long)identityV0.getRevision().toLong());
        Assert.assertEquals((long)0L, (long)identityV0.getBalance());
        Assert.assertNull((Object)identityV0.getPublicKey(0L));
        identity.delete();
        identifier1.delete();
    }

    @Test
    public void getIdentityTest() {
        Identifier identifier = new Identifier(contractIdentifier);
        Identity identity = dashsdk.getIdentity2((Identifier)identifier);
        Assert.assertNotNull((Object)identity);
        Assert.assertTrue((boolean)identity.swigCMemOwn);
        Assert.assertEquals((Object)Identity.Tag.V0, (Object)identity.getTag());
        IdentityV0 identityV0 = identity.getV0().get_0();
        Assert.assertEquals((long)2L, (long)identityV0.getBalance());
        Assert.assertEquals((long)1L, (long)identityV0.getRevision().toLong());
        Assert.assertEquals((long)2L, (long)identityV0.getPublicKeyCount());
        Assert.assertNotNull((Object)identityV0.getId());
        Assert.assertEquals((Object)identifier, (Object)identityV0.getId());
        Map map = identityV0.getPublicKeys();
        map.values().forEach(ipk -> {
            IdentityPublicKeyV0 ipkv0 = ipk.getV0().get_0();
            Assert.assertEquals((long)1L, (long)ipkv0.getId().toInt());
            Assert.assertFalse((boolean)ipkv0.getRead_only());
            Assert.assertEquals((Object)Purpose.AUTHENTICATION, (Object)ipkv0.getPurpose());
            Assert.assertEquals((Object)SecurityLevel.MASTER, (Object)ipkv0.getSecurityLevel());
            Assert.assertEquals((Object)KeyType.ECDSA_SECP256K1, (Object)ipkv0.getKeyType());
            Assert.assertNull((Object)ipkv0.getDisabled_at());
            Assert.assertEquals((long)33L, (long)ipkv0.getData().get_0().length);
            Assert.assertNull((Object)ipkv0.getContract_bounds());
        });
        for (int i = 0; i < identityV0.getPublicKeyCount(); ++i) {
            IdentityPublicKeyV0 ipkv0 = identityV0.getPublicKey((long)i);
            Assert.assertEquals((long)1L, (long)ipkv0.getId().toInt());
            Assert.assertFalse((boolean)ipkv0.getRead_only());
            Assert.assertEquals((Object)Purpose.AUTHENTICATION, (Object)ipkv0.getPurpose());
            Assert.assertEquals((Object)SecurityLevel.MASTER, (Object)ipkv0.getSecurityLevel());
            Assert.assertEquals((Object)KeyType.ECDSA_SECP256K1, (Object)ipkv0.getKeyType());
            Assert.assertNull((Object)ipkv0.getDisabled_at());
            Assert.assertEquals((long)33L, (long)ipkv0.getData().get_0().length);
            Assert.assertNull((Object)ipkv0.getContract_bounds());
        }
        IdentityPublicKeyV0 ipkv0 = identityV0.getPublicKey(0L);
        IdentityPublicKeyV0 identityPublicKeyV0ById = identityV0.getPublicKeyById(1L);
        Assert.assertEquals((long)ipkv0.getData().get_0().length, (long)identityPublicKeyV0ById.getData().get_0().length);
        Assert.assertArrayEquals((byte[])ipkv0.getData().get_0(), (byte[])identityPublicKeyV0ById.getData().get_0());
        identity.delete();
    }

    @Test
    public void getIdentityWithBoundsFromRustAndDestroyTest() {
        Identifier id = new Identifier(identifier);
        Identifier idContract = new Identifier(contractIdentifier);
        Identity identityWithBounds = dashsdk.getIdentityContractBounds((Identifier)id, (Identifier)idContract);
        Assert.assertNotNull((Object)identityWithBounds);
        Assert.assertTrue((boolean)identityWithBounds.swigCMemOwn);
        Assert.assertEquals((Object)Identity.Tag.V0, (Object)identityWithBounds.getTag());
        IdentityV0 identityV0 = identityWithBounds.getV0().get_0();
        Assert.assertEquals((long)2L, (long)identityV0.getBalance());
        Assert.assertEquals((long)1L, (long)identityV0.getRevision().toLong());
        Assert.assertEquals((long)2L, (long)identityV0.getPublicKeyCount());
        Assert.assertNotNull((Object)identityWithBounds.getV0().get_0().getId());
        Identifier myId = new Identifier(identifier);
        Assert.assertEquals((Object)myId, (Object)identityWithBounds.getV0().get_0().getId());
        myId.delete();
        for (int i = 0; i < identityV0.getPublicKeyCount(); ++i) {
            IdentityPublicKeyV0 ipkv0 = identityV0.getPublicKey((long)i);
            Assert.assertEquals((long)1L, (long)ipkv0.getId().toInt());
            Assert.assertFalse((boolean)ipkv0.getRead_only());
            Assert.assertEquals((Object)Purpose.AUTHENTICATION, (Object)ipkv0.getPurpose());
            Assert.assertEquals((Object)SecurityLevel.MASTER, (Object)ipkv0.getSecurityLevel());
            Assert.assertEquals((Object)KeyType.ECDSA_SECP256K1, (Object)ipkv0.getKeyType());
            Assert.assertNotNull((Object)ipkv0.getDisabled_at());
            Assert.assertEquals((long)33L, (long)ipkv0.getData().get_0().length);
            Assert.assertNotNull((Object)ipkv0.getContract_bounds());
            Assert.assertEquals((Object)ContractBounds.Tag.SingleContract, (Object)ipkv0.getContract_bounds().getTag());
            Assert.assertEquals((Object)idContract, (Object)ipkv0.getContract_bounds().getSingle_contract_document_type().getId());
        }
        IdentityPublicKeyV0 ipkv0 = identityV0.getPublicKey(0L);
        IdentityPublicKeyV0 identityPublicKeyV0ById = identityWithBounds.getV0().get_0().getPublicKeyById(1L);
        Assert.assertEquals((long)ipkv0.getData().get_0().length, (long)identityPublicKeyV0ById.getData().get_0().length);
        Assert.assertArrayEquals((byte[])ipkv0.getData().get_0(), (byte[])identityPublicKeyV0ById.getData().get_0());
        identityWithBounds.delete();
        id.delete();
        idContract.delete();
    }

    @Test
    public void createBasicIdentityInRustAndDestroyTest() {
        Identifier identifier = new Identifier(contractIdentifier);
        Identity identity = dashsdk.createBasicIdentity((byte[])identifier.get_0().get_0());
        Assert.assertNotNull((Object)identity);
        Assert.assertTrue((boolean)identity.swigCMemOwn);
        Assert.assertEquals((Object)Identity.Tag.V0, (Object)identity.getTag());
        IdentityV0 identityV0 = identity.getV0().get_0();
        Assert.assertArrayEquals((byte[])contractIdentifier, (byte[])identityV0.getId().get_0().get_0());
        Assert.assertEquals((long)0L, (long)identityV0.getRevision().toLong());
        Assert.assertEquals((long)0L, (long)identityV0.getBalance());
        Assert.assertEquals((long)0L, (long)identityV0.getPublicKeyCount());
        identity.delete();
        identifier.delete();
    }

    @Test
    public void createIdentityTest() {
        HashMap<KeyID, IdentityPublicKey> keyMap = new HashMap<KeyID, IdentityPublicKey>();
        for (int i = 0; i < 2; ++i) {
            IdentityPublicKeyV0 ipkv0 = new IdentityPublicKeyV0(new KeyID(i + 1), Purpose.AUTHENTICATION, SecurityLevel.MASTER, null, KeyType.BIP13_SCRIPT_HASH, false, new BinaryData(new byte[20]), new TimestampMillis());
            IdentityPublicKey ipk2 = new IdentityPublicKey(ipkv0);
            keyMap.put(new KeyID(i + 1), ipk2);
        }
        Identifier identifier1 = new Identifier(identifier);
        IdentityV0 identityV0 = new IdentityV0(identifier1, keyMap, BigInteger.TEN, new Revision(1));
        Identity identity = new Identity(identityV0);
        identity.getV0().get_0().getPublicKeys().values().forEach(ipk -> {
            IdentityPublicKeyV0 ipkv0 = ipk.getV0().get_0();
            Assert.assertEquals((Object)Purpose.AUTHENTICATION, (Object)ipkv0.getPurpose());
        });
        identifier1.delete();
        identityV0.delete();
        identity.delete();
    }

    @Test
    public void assetLockTest() {
        OutPoint outPoint = new OutPoint(identifier, 0L);
        Assert.assertEquals((long)0L, (long)outPoint.getIndex());
        Assert.assertArrayEquals((byte[])identifier, (byte[])outPoint.getTxid());
        InstantAssetLockProof instantAssetLockProof = new InstantAssetLockProof(identifier, identifier, 0L);
        Assert.assertArrayEquals((byte[])identifier, (byte[])instantAssetLockProof.getInstant_lock());
        Assert.assertArrayEquals((byte[])identifier, (byte[])instantAssetLockProof.getTransaction());
        Assert.assertEquals((long)0L, (long)instantAssetLockProof.getOutput_index());
        ChainAssetLockProof chainAssetLockProof = new ChainAssetLockProof(2000000L, outPoint);
        Assert.assertEquals((long)2000000L, (long)chainAssetLockProof.getCore_chain_locked_height());
        AssetLockProof instantProof = new AssetLockProof(instantAssetLockProof);
        Assert.assertEquals((Object)AssetLockProof.Tag.Instant, (Object)instantProof.getTag());
        Assert.assertArrayEquals((byte[])identifier, (byte[])instantProof.getInstant().get_0().getInstant_lock());
        Assert.assertArrayEquals((byte[])identifier, (byte[])instantProof.getInstant().get_0().getTransaction());
        Assert.assertEquals((long)0L, (long)instantProof.getInstant().get_0().getOutput_index());
        AssetLockProof chainProof = new AssetLockProof(chainAssetLockProof);
        Assert.assertEquals((Object)AssetLockProof.Tag.Chain, (Object)chainProof.getTag());
        Assert.assertEquals((long)2000000L, (long)chainProof.getChain().get_0().getCore_chain_locked_height());
        outPoint.delete();
    }
}

