/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk;

import java.util.Optional;
import org.bitcoinj.core.Base58;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.Identity;
import org.dashj.platform.sdk.IdentityV0;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.SdkBaseTest;
import org.dashj.platform.sdk.base.Result;
import org.dashj.platform.sdk.dashsdk;
import org.junit.Assert;
import org.junit.Test;

public class IdentityTest
extends SdkBaseTest {
    private static final String testIdentifier = "7Yowk46VwwHqmD5yZyyygggh937aP6h2UW7aQWBdWpM5";
    private static final String testIdentifierNotExist = "7Yowk46VwwHqmD5yZyyyhijh937aP6h2UW7aQWBdWpM5";

    @Test
    public void fetchIdentity3AndDestroy() throws Exception {
        Identifier identifier1 = new Identifier(Base58.decode((String)testIdentifier));
        Result result = dashsdk.platformMobileFetchIdentityFetchIdentityWithSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)identifier1);
        Identity identity = (Identity)((Optional)result.unwrap()).get();
        Assert.assertEquals((Object)Identity.Tag.V0, (Object)identity.getTag());
        IdentityV0 identityV0 = identity.getV0().get_0();
        Assert.assertNotNull((Object)identityV0);
        Assert.assertEquals((Object)identifier1, (Object)identityV0.getId());
        Assert.assertEquals((long)0L, (long)identityV0.getRevision().toLong());
        Assert.assertTrue((identityV0.getBalance() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)identityV0.getPublicKey(0L));
        identity.delete();
        identifier1.delete();
    }

    @Test
    public void fetchIdentity3FailAndDestroy() throws Exception {
        Identifier identifier1 = new Identifier(identifier);
        Result result = dashsdk.platformMobileFetchIdentityFetchIdentityWithSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)new Identifier(Base58.decode((String)testIdentifierNotExist)));
        Assert.assertTrue((boolean)((Optional)result.unwrap()).isEmpty());
        identifier1.delete();
    }

    @Test
    public void identityBalanceTest() throws Exception {
        Identifier id = new Identifier(Base58.decode((String)testIdentifier));
        Result result2 = dashsdk.platformMobileFetchIdentityFetchIdentityBalanceWithSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)id);
        result2.unwrap();
    }
}

