/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.dashj.platform.sdk.BaseTest;
import org.dashj.platform.sdk.Hash256;
import org.dashj.platform.sdk.PlatformValue;
import org.dashj.platform.sdk.PlatformValueMap;
import org.dashj.platform.sdk.dashsdk;
import org.junit.Assert;
import org.junit.Test;

public class ValueTest
extends BaseTest {
    @Test
    public void getPlatformValueTest() {
        PlatformValue value = dashsdk.platformMobileTestsGetPlatformValueBool((boolean)false);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)PlatformValue.Tag.Bool, (Object)value.getTag());
        Assert.assertFalse((boolean)value.getBool());
        value.delete();
    }

    @Test
    public void getPlatformValueMapTest() {
        PlatformValue value = dashsdk.platformMobileTestsGetPlatformValueWithMap();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)PlatformValue.Tag.Map, (Object)value.getTag());
        PlatformValueMap valueMap = value.getMap();
        Map map = valueMap.get_0();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)1L, (long)map.size());
        map.forEach((k, v) -> {
            Assert.assertEquals((Object)PlatformValue.Tag.Text, (Object)k.getTag());
            Assert.assertEquals((Object)PlatformValue.Tag.I32, (Object)v.getTag());
        });
        value.delete();
    }

    @Test
    public void createPlatformValueTest() {
        PlatformValue v1 = new PlatformValue(1);
        Assert.assertEquals((Object)PlatformValue.Tag.I8, (Object)v1.getTag());
        Assert.assertEquals((long)1L, (long)v1.getI8());
        PlatformValue v3 = new PlatformValue(1);
        Assert.assertEquals((Object)PlatformValue.Tag.I32, (Object)v3.getTag());
        Assert.assertEquals((long)1L, (long)v3.getI32());
        PlatformValue v4 = new PlatformValue(1L);
        Assert.assertEquals((Object)PlatformValue.Tag.I64, (Object)v4.getTag());
        Assert.assertEquals((long)1L, (long)v4.getI64());
        PlatformValue v5 = new PlatformValue("text");
        Assert.assertEquals((Object)PlatformValue.Tag.Text, (Object)v5.getTag());
        Assert.assertEquals((Object)"text", (Object)v5.getText());
        PlatformValue v6 = new PlatformValue();
        Assert.assertEquals((Object)PlatformValue.Tag.Null, (Object)v6.getTag());
        v1.delete();
        v3.delete();
        v4.delete();
        v5.delete();
        v6.delete();
    }

    @Test
    public void createPlatformValueMapTest() {
        PlatformValue key = new PlatformValue("key");
        PlatformValue listKey = new PlatformValue("listKey");
        PlatformValue value = new PlatformValue("value");
        HashMap<PlatformValue, PlatformValue> kvMap = new HashMap<PlatformValue, PlatformValue>();
        kvMap.put(key, value);
        ArrayList<PlatformValue> list = new ArrayList<PlatformValue>();
        list.add(key);
        list.add(value);
        PlatformValue listValue = new PlatformValue(list);
        kvMap.put(listKey, listValue);
        HashMap<String, PlatformValue> javaValueMap = new HashMap<String, PlatformValue>();
        javaValueMap.put("map", new PlatformValue(new PlatformValueMap(kvMap)));
        Assert.assertEquals((Object)PlatformValue.Tag.Map, (Object)((PlatformValue)javaValueMap.get("map")).getTag());
        PlatformValue value1 = (PlatformValue)javaValueMap.get("map");
        PlatformValueMap valueMap1 = value1.getMap();
        Map map1 = valueMap1.get_0();
        map1.forEach((k, v) -> {
            System.out.printf("%s:%s\n", k.getTag(), v.getTag());
            Assert.assertEquals((Object)PlatformValue.Tag.Text, (Object)k.getTag());
            System.out.printf("%s:", k.getText());
            if (v.getTag() == PlatformValue.Tag.Text) {
                System.out.printf("%s", v.getText());
            } else if (v.getTag() == PlatformValue.Tag.Array) {
                System.out.print("[");
                v.getArray().forEach(item -> System.out.printf("%s,", item.getText()));
                System.out.print("]");
            }
            System.out.println();
        });
        Assert.assertNotNull(map1.get(key));
        Assert.assertEquals((Object)value, map1.get(key));
        Assert.assertNotEquals((long)value.getCPointer(), (long)((PlatformValue)map1.get(key)).getCPointer());
    }

    @Test
    public void createPlatformValueArrayTest() {
        PlatformValue key = new PlatformValue("key");
        PlatformValue listKey = new PlatformValue("listKey");
        PlatformValue value = new PlatformValue("value");
        ArrayList<PlatformValue> list = new ArrayList<PlatformValue>();
        list.add(key);
        list.add(value);
        PlatformValue listValues = new PlatformValue(list);
        listValues.getArray().forEach(v -> {
            System.out.printf("tag: %s\n", v.getTag());
            if (v.getTag() == PlatformValue.Tag.Text) {
                System.out.printf("%s", v.getText());
            } else if (v.getTag() == PlatformValue.Tag.Array) {
                System.out.print("[");
                value.getArray().forEach(item -> System.out.printf("%s,", item.getText()));
                System.out.print("[");
            }
            System.out.println();
        });
    }

    public static <T> void testValue(T value, PlatformValue.Tag tag, Construct constructor, MyTest<T> tester) {
        PlatformValue platformValue = constructor.construct();
        Assert.assertEquals((Object)tag, (Object)platformValue.getTag());
        Assert.assertEquals(value, tester.get(platformValue));
        platformValue.delete();
    }

    public static <T> void testArrayValue(byte[] value, PlatformValue.Tag tag, Construct constructor, MyArrayTest<T> tester) {
        PlatformValue platformValue = constructor.construct();
        Assert.assertEquals((Object)tag, (Object)platformValue.getTag());
        Assert.assertArrayEquals((byte[])value, (byte[])tester.get(platformValue));
        platformValue.delete();
    }

    @Test
    public void createPlatformValuePrimitiveTest() {
        ValueTest.testValue(true, PlatformValue.Tag.Bool, () -> new PlatformValue(true), PlatformValue::getBool);
        BigInteger i128Value = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.ONE);
        ValueTest.testValue(i128Value, PlatformValue.Tag.I128, () -> new PlatformValue(i128Value), PlatformValue::getI128);
        ValueTest.testValue((byte)1, PlatformValue.Tag.I8, () -> new PlatformValue(1), PlatformValue::getI8);
        ValueTest.testValue((short)Short.MAX_VALUE, PlatformValue.Tag.I16, () -> new PlatformValue(Short.MAX_VALUE), PlatformValue::getI16);
        ValueTest.testValue(Integer.MAX_VALUE, PlatformValue.Tag.I32, () -> new PlatformValue(Integer.MAX_VALUE), PlatformValue::getI32);
        ValueTest.testValue(Long.MAX_VALUE, PlatformValue.Tag.I64, () -> new PlatformValue(Long.MAX_VALUE), PlatformValue::getI64);
        ValueTest.testValue(Double.MAX_VALUE, PlatformValue.Tag.Float, () -> new PlatformValue(Double.MAX_VALUE), PlatformValue::getFloat);
        ValueTest.testValue("text", PlatformValue.Tag.Text, () -> new PlatformValue("text"), PlatformValue::getText);
    }

    @Test
    public void createPlatformValueVectorsTest() {
        ValueTest.testArrayValue(identifier, PlatformValue.Tag.Bytes, () -> new PlatformValue(identifier, false), PlatformValue::getBytes);
        byte[] hash160 = Arrays.copyOfRange(identifier, 0, 20);
        ValueTest.testArrayValue(hash160, PlatformValue.Tag.Bytes20, () -> new PlatformValue(hash160, true), PlatformValue::getBytes20);
        ValueTest.testArrayValue(identifier, PlatformValue.Tag.Bytes32, () -> new PlatformValue(identifier, true), PlatformValue::getBytes32);
        byte[] outpointBytes = Arrays.copyOf(identifier, 36);
        ValueTest.testArrayValue(outpointBytes, PlatformValue.Tag.Bytes36, () -> new PlatformValue(outpointBytes, true), PlatformValue::getBytes36);
        byte[] bytes = Arrays.copyOfRange(identifier, 0, 16);
        ValueTest.testArrayValue(bytes, PlatformValue.Tag.Bytes, () -> new PlatformValue(bytes, true), PlatformValue::getBytes);
        ValueTest.testArrayValue(identifier, PlatformValue.Tag.Identifier, () -> new PlatformValue(new Hash256(identifier)), v -> v.getIdentifier().getBytes());
    }

    @Test
    public void createPlatformValueVectorsTestTwo() {
        PlatformValue bytes20 = new PlatformValue(identifier, true);
        Assert.assertEquals((Object)PlatformValue.Tag.Bytes32, (Object)bytes20.getTag());
        bytes20.delete();
    }

    @Test
    public void accessInvalidTypeTest() {
        PlatformValue platformValue = new PlatformValue("text");
        platformValue.getText();
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getI128());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getI64());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getI32());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getI8());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getFloat());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getArray());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getMap());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getBytes());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getBytes20());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getBytes32());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getBytes36());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getIdentifier());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getEnumString());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getArray());
        Assert.assertThrows(IllegalArgumentException.class, () -> ((PlatformValue)platformValue).getMap());
    }

    static interface Construct {
        public PlatformValue construct();
    }

    static interface MyArrayTest<T> {
        public byte[] get(PlatformValue var1);
    }

    static interface MyTest<T> {
        public T get(PlatformValue var1);
    }
}

