/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.DumpedPrivateKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bitcoinj.params.TestNet3Params;
import org.dashj.platform.sdk.ContenderWithSerializedDocument;
import org.dashj.platform.sdk.Contenders;
import org.dashj.platform.sdk.ContestedDocumentResourceVotePoll;
import org.dashj.platform.sdk.ContestedDocumentVotePollWinnerInfo;
import org.dashj.platform.sdk.ContestedResource;
import org.dashj.platform.sdk.ContestedResources;
import org.dashj.platform.sdk.Document;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.Identity;
import org.dashj.platform.sdk.IdentityPublicKey;
import org.dashj.platform.sdk.PlatformValue;
import org.dashj.platform.sdk.ResourceVote;
import org.dashj.platform.sdk.ResourceVoteChoice;
import org.dashj.platform.sdk.ResourceVoteV0;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.SdkBaseTest;
import org.dashj.platform.sdk.TimestampMillis;
import org.dashj.platform.sdk.TupleContestedDocumentVotePollWinnerInfoBlockInfo;
import org.dashj.platform.sdk.TupleTimeStampMillisVotePoll;
import org.dashj.platform.sdk.Vote;
import org.dashj.platform.sdk.VotePoll;
import org.dashj.platform.sdk.VotePollsGroupedByTimeStamp;
import org.dashj.platform.sdk.base.Result;
import org.dashj.platform.sdk.callbacks.Signer;
import org.dashj.platform.sdk.dashsdk;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class VoteTest
extends SdkBaseTest {
    @Test
    public void getVoteContendorsTest() throws Exception {
        String name = "test100";
        ArrayList<PlatformValue> indexes = new ArrayList<PlatformValue>();
        indexes.add(new PlatformValue("dash"));
        indexes.add(new PlatformValue(name));
        Result result = dashsdk.platformMobileVotingGetVoteContenders((SWIGTYPE_p_DashSdk)sdk, (String)"parentNameAndLabel", indexes, (String)"domain", (Identifier)new Identifier(dpnsContractId));
        Contenders contenders = (Contenders)result.unwrap();
        Assert.assertNotNull((Object)contenders);
        System.out.println("Username: " + name);
        System.out.println("Contenders: " + contenders.getContenders().size());
        TupleContestedDocumentVotePollWinnerInfoBlockInfo winner = contenders.getWinner();
        System.out.println("  Winner:" + (winner != null ? "" : "none"));
        if (winner != null) {
            System.out.print("  " + winner.getO_0().getTag());
            if (winner.getO_0().getTag() == ContestedDocumentVotePollWinnerInfo.Tag.WonByIdentity) {
                System.out.print(" " + Base58.encode((byte[])winner.getO_0().getWon_by_identity().get_0().get_0().get_0()));
            }
            System.out.println();
        }
        System.out.println("  Abstain: " + contenders.getAbstainVoteTally());
        System.out.println("  Lock: " + contenders.getLockVoteTally());
        System.out.println("  ---------------");
        for (Map.Entry entry : contenders.getContenders().entrySet()) {
            System.out.println("    Identifier: " + Base58.encode((byte[])((Identifier)entry.getKey()).get_0().get_0()));
            byte[] serializedDocument = ((ContenderWithSerializedDocument)entry.getValue()).getV0().get_0().getSerialized_document();
            System.out.println("    Serialized: " + (serializedDocument != null ? Base64.getEncoder().encodeToString(serializedDocument) : "null"));
            if (serializedDocument != null) {
                Result result2 = dashsdk.platformMobileFetchDocumentDeserializeDocumentSdk((SWIGTYPE_p_DashSdk)sdk, (byte[])serializedDocument, (Identifier)new Identifier(dpnsContractId), (String)"domain");
                Document document = (Document)result2.unwrap();
                long createdAt = document.getV0().get_0().getCreated_at().toLong();
                System.out.println("    createdAt: " + DateFormat.getDateInstance(1).format(createdAt));
            }
            System.out.println("    Votes: " + ((ContenderWithSerializedDocument)entry.getValue()).getV0().get_0().getVoteTally());
            System.out.println("    ---------------");
        }
    }

    @Test
    public void getVoteContendorsMainNetTest() throws Exception {
        String name = "fuzzyduck";
        ArrayList<PlatformValue> indexes = new ArrayList<PlatformValue>();
        indexes.add(new PlatformValue("dash"));
        indexes.add(new PlatformValue(name));
        SWIGTYPE_p_DashSdk mainnetSdk = dashsdk.platformMobileSdkCreateDashSdk((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.ZERO, (boolean)false);
        Result result = dashsdk.platformMobileVotingGetVoteContenders((SWIGTYPE_p_DashSdk)mainnetSdk, (String)"parentNameAndLabel", indexes, (String)"domain", (Identifier)new Identifier(dpnsContractId));
        Contenders contenders = (Contenders)result.unwrap();
        Assert.assertNotNull((Object)contenders);
        System.out.println("Username: " + name);
        System.out.println("Contenders: " + contenders.getContenders().size());
        TupleContestedDocumentVotePollWinnerInfoBlockInfo winner = contenders.getWinner();
        System.out.println("  Winner:" + (winner != null ? "" : "none"));
        if (winner != null) {
            System.out.print("  " + winner.getO_0().getTag());
            if (winner.getO_0().getTag() == ContestedDocumentVotePollWinnerInfo.Tag.WonByIdentity) {
                System.out.print(" " + Base58.encode((byte[])winner.getO_0().getWon_by_identity().get_0().get_0().get_0()));
            }
            System.out.println();
        }
        System.out.println("  Abstain: " + contenders.getAbstainVoteTally());
        System.out.println("  Lock: " + contenders.getLockVoteTally());
        System.out.println("  ---------------");
        for (Map.Entry entry : contenders.getContenders().entrySet()) {
            System.out.println("    Identifier: " + Base58.encode((byte[])((Identifier)entry.getKey()).get_0().get_0()));
            byte[] serializedDocument = ((ContenderWithSerializedDocument)entry.getValue()).getV0().get_0().getSerialized_document();
            System.out.println("    Serialized: " + (serializedDocument != null ? Base64.getEncoder().encodeToString(serializedDocument) : "null"));
            if (serializedDocument != null) {
                Result result2 = dashsdk.platformMobileFetchDocumentDeserializeDocumentSdk((SWIGTYPE_p_DashSdk)sdk, (byte[])serializedDocument, (Identifier)new Identifier(dpnsContractId), (String)"domain");
                Document document = (Document)result2.unwrap();
                long createdAt = document.getV0().get_0().getCreated_at().toLong();
                System.out.println("    createdAt: " + DateFormat.getDateInstance(1).format(createdAt));
            }
            System.out.println("    Votes: " + ((ContenderWithSerializedDocument)entry.getValue()).getV0().get_0().getVoteTally());
            System.out.println("    ---------------");
        }
        dashsdk.platformMobileSdkDestroyDashSdk((SWIGTYPE_p_DashSdk)mainnetSdk);
    }

    @Test
    public void getVoteContendorsForNonExistantTest() throws Exception {
        ArrayList<PlatformValue> indexes = new ArrayList<PlatformValue>();
        indexes.add(new PlatformValue("dash"));
        indexes.add(new PlatformValue("test11101010010110101010"));
        Result result = dashsdk.platformMobileVotingGetVoteContenders((SWIGTYPE_p_DashSdk)sdk, (String)"parentNameAndLabel", indexes, (String)"domain", (Identifier)new Identifier(dpnsContractId));
        Contenders contenders = (Contenders)result.unwrap();
        Assert.assertNotNull((Object)contenders);
        System.out.println("Contenders: " + contenders.getContenders().size());
        System.out.println("  Abstain: " + contenders.getAbstainVoteTally());
        System.out.println("  Lock: " + contenders.getLockVoteTally());
        for (Map.Entry entry : contenders.getContenders().entrySet()) {
            System.out.println("  Identifier: " + Base58.encode((byte[])((Identifier)entry.getKey()).get_0().get_0()));
            System.out.println("  " + ((ContenderWithSerializedDocument)entry.getValue()).getV0().get_0().getVoteTally());
        }
    }

    @Test
    public void getContestedResources() throws Exception {
        Result result = dashsdk.platformMobileVotingGetContestedResources((SWIGTYPE_p_DashSdk)sdk, (String)"domain", (Identifier)new Identifier(dpnsContractId), (int)100, null, (boolean)false);
        ContestedResources contestedResources = (ContestedResources)result.unwrap();
        Assert.assertNotNull((Object)contestedResources);
        List list = contestedResources.get_0();
        for (ContestedResource item : list) {
            System.out.println(item.getValue().getText());
        }
    }

    @Test
    public void getVotePoolsTest() throws Exception {
        Result result = dashsdk.platformMobileVotingGetVotePolls((SWIGTYPE_p_DashSdk)sdk, (TimestampMillis)new TimestampMillis(System.currentTimeMillis()), (boolean)true, (TimestampMillis)new TimestampMillis(System.currentTimeMillis() + 1209600000L), (boolean)true, (int)100, (int)0, (boolean)true);
        VotePollsGroupedByTimeStamp votePolls = (VotePollsGroupedByTimeStamp)result.unwrap();
        Assert.assertNotNull((Object)votePolls);
        List list = votePolls.get_0();
        System.out.println("results returned: " + list.size());
        for (TupleTimeStampMillisVotePoll item : list) {
            System.out.println("timestamp: " + item.getO_0().get_0().longValue());
            for (VotePoll votePoll : item.getO_1()) {
                System.out.println(votePoll.getContested_document_resource_vote_poll().get_0().getDocument_type_name());
            }
        }
    }

    @Test
    public void putToPlatformTest() throws Exception {
        ArrayList<PlatformValue> indexes = new ArrayList<PlatformValue>();
        String name = "rev1ew000";
        indexes.add(new PlatformValue("dash"));
        indexes.add(new PlatformValue(name));
        Identifier dpnsIdentifier = new Identifier(dpnsContractId);
        Result contendersResult = dashsdk.platformMobileVotingGetVoteContenders((SWIGTYPE_p_DashSdk)sdk, (String)"parentNameAndLabel", indexes, (String)"domain", (Identifier)dpnsIdentifier);
        Assert.assertFalse((boolean)((Contenders)contendersResult.unwrap()).getContenders().isEmpty());
        ContestedDocumentResourceVotePoll contestedDocumentResourceVotePoll = new ContestedDocumentResourceVotePoll(dpnsIdentifier, "domain", "parentNameAndLabel", indexes);
        Assert.assertEquals((Object)dpnsIdentifier, (Object)contestedDocumentResourceVotePoll.getContract_id());
        Assert.assertEquals((Object)"domain", (Object)contestedDocumentResourceVotePoll.getDocument_type_name());
        Assert.assertEquals((Object)"parentNameAndLabel", (Object)contestedDocumentResourceVotePoll.getIndex_name());
        Assert.assertEquals(indexes, (Object)contestedDocumentResourceVotePoll.getIndex_values());
        VotePoll votePoll = new VotePoll(contestedDocumentResourceVotePoll);
        ResourceVoteChoice resourceVoteChoice = new ResourceVoteChoice(ResourceVoteChoice.Tag.TowardsIdentity, new Identifier(Base58.decode((String)"87ehECsR368RgMtPcAgxBkHJUNvHyN6tSKS3AXw2TZbZ")));
        ResourceVoteV0 resourceVoteV0 = new ResourceVoteV0(votePoll, resourceVoteChoice);
        ResourceVote resourceVote = new ResourceVote(resourceVoteV0);
        Vote myVote = new Vote(resourceVote);
        final DumpedPrivateKey privateKey = DumpedPrivateKey.fromBase58((NetworkParameters)TestNet3Params.get(), (String)"cRiBg3AhEH7XhqZ6vQSyKFH8DTjQe8YiRirZ539TmfndNpNw6go1");
        byte[] proTxHash = Utils.HEX.decode((CharSequence)"bc77a5a2cec455c79fb92fb683dbd87a2a92b663c9a46d0c50d11889b4aeb121");
        ByteArrayOutputStream boas = new ByteArrayOutputStream(52);
        boas.write(proTxHash);
        boas.write(privateKey.getKey().getPubKeyHash());
        Sha256Hash idBytes = Sha256Hash.of((byte[])boas.toByteArray());
        System.out.println(Base58.encode((byte[])idBytes.getBytes()));
        Result identityResult = dashsdk.platformMobileFetchIdentityFetchIdentityWithSdk((SWIGTYPE_p_DashSdk)sdk, (Identifier)new Identifier(idBytes.getBytes()));
        try {
            Identity identity = (Identity)((Optional)identityResult.unwrap()).get();
            IdentityPublicKey ipk = (IdentityPublicKey)identity.getV0().get_0().getPublicKeys().values().stream().findFirst().get();
            Signer signer = new Signer(){

                public byte[] sign(byte @NotNull [] key, byte @NotNull [] data) {
                    return privateKey.getKey().signHash(Sha256Hash.twiceOf((byte[])data));
                }
            };
            Result result = dashsdk.platformMobileVotingPutVoteToPlatform((SWIGTYPE_p_DashSdk)sdk, (Vote)myVote, (Identifier)new Identifier(proTxHash), (IdentityPublicKey)ipk, (long)signer.getNativeContext(), (BigInteger)BigInteger.valueOf(signer.getSignerCallback()));
            Vote resourceVoteFromPlatform = (Vote)result.unwrap();
            Assert.assertNotNull((Object)resourceVoteFromPlatform);
            System.out.println("Vote: " + resourceVoteFromPlatform.getResource_vote().get_0().getV0().get_0().getResource_vote_choice().getTag());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

