/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.unittest.utils.matchers.StreamBasedMatcherSupport;
import org.echocat.unittest.utils.utils.StreamUtils;
import org.hamcrest.Matcher;

public class ContainsOnlyElementsThat<V, T>
extends StreamBasedMatcherSupport<V, T> {
    protected ContainsOnlyElementsThat(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Matcher<T> firstMatcher, @Nullable Matcher<T>[] otherMatchers) {
        super(mapper, firstMatcher, otherMatchers);
    }

    protected ContainsOnlyElementsThat(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Iterable<Matcher<T>> matchers) {
        super(mapper, matchers);
    }

    @Override
    protected boolean matches(@Nonnull Stream<T> items) {
        AtomicBoolean everyItemWasTrue = new AtomicBoolean(true);
        AtomicBoolean hasAtLeastOneItem = new AtomicBoolean(false);
        items.forEach(item -> this.matchers().forEach(matcher -> {
            hasAtLeastOneItem.set(true);
            if (!matcher.matches(item)) {
                everyItemWasTrue.set(false);
            }
        }));
        return everyItemWasTrue.get() && hasAtLeastOneItem.get();
    }

    @Override
    protected String description() {
        return "contains only elements that";
    }

    public static interface Arrays {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<T[]> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsOnlyElementsThat<Object[], T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }

    public static interface Spliterators {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<Spliterator<T>> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsOnlyElementsThat<Spliterator, T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }

    public static interface Iterators {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<Iterator<T>> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsOnlyElementsThat<Iterator, T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }

    public static interface Iterables {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<Iterable<T>> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsOnlyElementsThat<Iterable, T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }

    public static interface Streams {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<Stream<T>> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsOnlyElementsThat<Stream, T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }
}

