/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public abstract class StreamBasedMatcherSupport<V, T>
extends BaseMatcher<V> {
    @Nonnegative
    protected static final int MAXIMUM_MISMATCHES_TO_REPORT = 10;
    @Nonnull
    private final Function<V, Stream<T>> mapper;
    @Nonnull
    private final Iterable<Matcher<T>> matchers;

    protected StreamBasedMatcherSupport(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Matcher<T> firstMatcher, @Nullable Matcher<T>[] otherMatchers) {
        this(mapper, StreamBasedMatcherSupport.collectMatchers(firstMatcher, otherMatchers));
    }

    protected StreamBasedMatcherSupport(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Iterable<Matcher<T>> matchers) {
        this.mapper = mapper;
        this.matchers = matchers;
    }

    @Nonnull
    protected static <T> Iterable<Matcher<T>> collectMatchers(@Nonnull Matcher<T> firstMatcher, @Nullable Matcher<T>[] otherMatchers) {
        ArrayList<Matcher<T>> result = new ArrayList<Matcher<T>>(1 + (otherMatchers != null ? otherMatchers.length : 0));
        result.add(firstMatcher);
        if (otherMatchers != null) {
            Collections.addAll(result, otherMatchers);
        }
        return Collections.unmodifiableList(result);
    }

    @Nonnull
    protected Function<V, Stream<T>> mapper() {
        return this.mapper;
    }

    @Nonnull
    protected Iterable<Matcher<T>> matchers() {
        return this.matchers;
    }

    public boolean matches(@Nullable Object item) {
        if (item == null) {
            return false;
        }
        return this.matches(this.mapper.apply(item));
    }

    protected abstract boolean matches(@Nonnull Stream<T> var1);

    public void describeMismatch(@Nullable Object item, @Nonnull Description description) {
        if (item == null) {
            description.appendText("is null");
            return;
        }
        this.describeMismatch(this.mapper.apply(item), description);
    }

    protected void describeMismatch(@Nonnull Stream<T> items, @Nonnull Description description) {
        AtomicBoolean firstElementPrinted = new AtomicBoolean();
        AtomicLong printedMismatchedElements = new AtomicLong();
        items.forEach(item -> {
            AtomicBoolean firstMatcherPrinted = new AtomicBoolean();
            if (printedMismatchedElements.get() < 10L) {
                for (Matcher<T> matcher : this.matchers()) {
                    if (matcher.matches(item)) continue;
                    if (firstElementPrinted.getAndSet(true)) {
                        description.appendText("\n          ");
                    }
                    if (firstMatcherPrinted.getAndSet(true)) {
                        description.appendText("    and ");
                    } else {
                        description.appendText("for ").appendValue(item).appendText(" ");
                        printedMismatchedElements.incrementAndGet();
                    }
                    description.appendDescriptionOf(matcher).appendText(" ");
                    matcher.describeMismatch(item, description);
                }
            } else if (printedMismatchedElements.get() < 11L) {
                description.appendText("\n          [...]");
                printedMismatchedElements.incrementAndGet();
            }
        });
    }

    public void describeTo(@Nonnull Description description) {
        AtomicBoolean firstMatcherPrinted = new AtomicBoolean();
        this.matchers().forEach(matcher -> {
            if (firstMatcherPrinted.getAndSet(true)) {
                description.appendText("\n              and ");
            } else {
                description.appendText(this.description()).appendText(" ");
            }
            description.appendDescriptionOf((SelfDescribing)matcher);
        });
    }

    protected abstract String description();
}

