/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.nio;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.echocat.unittest.utils.nio.WrappedFileSystem;

@FunctionalInterface
public interface WrappedPath
extends Path {
    @Nonnull
    public Path wrapped();

    @Override
    default public FileSystem getFileSystem() {
        return new WrappedFileSystem(this.getClass(), this.wrapped().getFileSystem());
    }

    @Override
    default public boolean isAbsolute() {
        return this.wrapped().isAbsolute();
    }

    @Override
    default public Path getRoot() {
        return this.wrapped().getRoot();
    }

    @Override
    default public Path getFileName() {
        return this.wrapped().getFileName();
    }

    @Override
    default public Path getParent() {
        return this.wrapped().getParent();
    }

    @Override
    default public int getNameCount() {
        return this.wrapped().getNameCount();
    }

    @Override
    default public Path getName(int index) {
        return this.wrapped().getName(index);
    }

    @Override
    default public Path subpath(int beginIndex, int endIndex) {
        return this.wrapped().subpath(beginIndex, endIndex);
    }

    @Override
    default public boolean startsWith(Path other) {
        return this.wrapped().startsWith(other);
    }

    @Override
    default public boolean startsWith(String other) {
        return this.wrapped().startsWith(other);
    }

    @Override
    default public boolean endsWith(Path other) {
        return this.wrapped().endsWith(other);
    }

    @Override
    default public boolean endsWith(String other) {
        return this.wrapped().endsWith(other);
    }

    @Override
    default public Path normalize() {
        return this.wrapped().normalize();
    }

    @Override
    default public Path resolve(Path other) {
        return this.wrapped().resolve(other);
    }

    @Override
    default public Path resolve(String other) {
        return this.wrapped().resolve(other);
    }

    @Override
    default public Path resolveSibling(Path other) {
        return this.wrapped().resolveSibling(other);
    }

    @Override
    default public Path resolveSibling(String other) {
        return this.wrapped().resolveSibling(other);
    }

    @Override
    default public Path relativize(Path other) {
        return this.wrapped().relativize(other);
    }

    @Override
    default public URI toUri() {
        return this.wrapped().toUri();
    }

    @Override
    default public Path toAbsolutePath() {
        return this.wrapped().toAbsolutePath();
    }

    @Override
    default public Path toRealPath(LinkOption ... options) throws IOException {
        return this.wrapped().toRealPath(options);
    }

    @Override
    default public File toFile() {
        return this.wrapped().toFile();
    }

    @Override
    default public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.wrapped().register(watcher, events, modifiers);
    }

    @Override
    default public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events) throws IOException {
        return this.wrapped().register(watcher, events);
    }

    @Override
    @Nonnull
    default public Iterator<Path> iterator() {
        return this.wrapped().iterator();
    }

    @Override
    default public int compareTo(Path other) {
        return this.wrapped().compareTo(other);
    }
}

