/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class StreamUtils {
    @Nonnull
    public static Stream<Object> toStream(@Nonnull Object input) {
        Objects.requireNonNull(input, "There are not objects provided.");
        if (input instanceof Object[]) {
            return StreamUtils.toStream((Object[])input);
        }
        if (input instanceof Collection) {
            return StreamUtils.toStream((Collection)input);
        }
        if (input instanceof Iterable) {
            return StreamUtils.toStream((Iterable)input);
        }
        if (input instanceof Iterator) {
            return StreamUtils.toStream((Iterator)input);
        }
        if (input instanceof Spliterator) {
            return StreamUtils.toStream((Spliterator)input);
        }
        if (input instanceof Stream) {
            return (Stream)input;
        }
        throw new IllegalArgumentException("Could not handle input of type: " + input.getClass().getName());
    }

    @SafeVarargs
    @Nonnull
    public static <T> Stream<T> toStream(T ... input) {
        return Stream.of(input);
    }

    @Nonnull
    public static <T> Stream<T> toStream(@Nonnull Collection<T> input) {
        return input.stream();
    }

    @Nonnull
    public static <T> Stream<T> toStream(@Nonnull Iterable<T> input) {
        return StreamUtils.toStream(input.spliterator());
    }

    @Nonnull
    public static <T> Stream<T> toStream(@Nonnull Iterator<T> input) {
        return StreamUtils.toStream(Spliterators.spliteratorUnknownSize(input, 16));
    }

    @Nonnull
    public static <T> Stream<T> toStream(@Nonnull Spliterator<T> input) {
        return StreamSupport.stream(input, false);
    }

    @Nonnull
    public static <T> Stream<T> toStream(@Nonnull Stream<T> input) {
        return input;
    }
}

