/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import javax.annotation.Nonnull;
import org.echocat.unittest.utils.matchers.CombinedMappingMatcher;
import org.echocat.unittest.utils.matchers.ContainsAtLeastOneElementThat;
import org.echocat.unittest.utils.matchers.ContainsOnlyElementsThat;
import org.echocat.unittest.utils.utils.StreamUtils;
import org.hamcrest.Matcher;

public final class ArrayMatchers {
    @Nonnull
    public static <T> Matcher<T[]> containsOnlyElementsThat(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return new ContainsOnlyElementsThat(StreamUtils::toStream, matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T[]> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return ArrayMatchers.containsOnlyElementsThat(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<T[]> containsOnlyElements(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return ArrayMatchers.containsOnlyElementsThat(matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T[]> containsOnlyElements(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return ArrayMatchers.containsOnlyElements(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<T[]> containsAtLeastOneElementThat(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return new ContainsAtLeastOneElementThat(StreamUtils::toStream, matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T[]> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return ArrayMatchers.containsAtLeastOneElementThat(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<T[]> containsAtLeastOneElement(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return ArrayMatchers.containsAtLeastOneElementThat(matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T[]> containsAtLeastOneElement(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return ArrayMatchers.containsAtLeastOneElement(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }
}

