/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.echocat.unittest.utils.matchers.CombinedMappingMatcher;
import org.echocat.unittest.utils.matchers.ContainsAtLeastOneElementThat;
import org.echocat.unittest.utils.matchers.ContainsOnlyElementsThat;
import org.echocat.unittest.utils.utils.StreamUtils;
import org.hamcrest.Matcher;

public final class StreamMatchers {
    @Nonnull
    public static <T> Matcher<Stream<T>> containsOnlyElementsThat(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return new ContainsOnlyElementsThat(StreamUtils::toStream, matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Stream<T>> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return StreamMatchers.containsOnlyElementsThat(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Stream<T>> containsOnlyElements(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return StreamMatchers.containsOnlyElementsThat(matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Stream<T>> containsOnlyElements(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return StreamMatchers.containsOnlyElements(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Stream<T>> containsAtLeastOneElementThat(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return new ContainsAtLeastOneElementThat(StreamUtils::toStream, matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Stream<T>> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return StreamMatchers.containsAtLeastOneElementThat(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Stream<T>> containsAtLeastOneElement(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return StreamMatchers.containsAtLeastOneElementThat(matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Stream<T>> containsAtLeastOneElement(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return StreamMatchers.containsAtLeastOneElement(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }
}

