/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ThrowsException<T extends Execution>
extends TypeSafeMatcher<T> {
    @Nonnull
    protected static final Throwable NONE = new Throwable(){};
    @Nonnull
    private final Map<Execution, Throwable> executionToThrowable = Collections.synchronizedMap(new WeakHashMap());
    @Nonnull
    private final Class<? extends Throwable> expectedExceptionType;
    @Nonnull
    private final Optional<Pattern> expectedExceptionMessagePattern;

    @Nonnull
    public static <T extends Execution> Matcher<T> throwsException(@Nonnull Class<? extends Throwable> type, @Nullable Pattern messagePattern) {
        return new ThrowsException<T>(type, messagePattern);
    }

    @Nonnull
    public static <T extends Execution> Matcher<T> throwsException(@Nonnull Class<? extends Throwable> type, @Nullable String messagePattern) {
        return ThrowsException.throwsException(type, messagePattern != null ? Pattern.compile(messagePattern, 32) : null);
    }

    @Nonnull
    public static <T extends Execution> Matcher<T> throwsException(@Nonnull Class<? extends Throwable> type) {
        return ThrowsException.throwsException(type, (Pattern)null);
    }

    @Nonnull
    public static <T extends Execution> Matcher<T> throwsExceptionWithMessage(@Nonnull Class<? extends Throwable> type, @Nullable Pattern messagePattern) {
        return ThrowsException.throwsException(type, messagePattern);
    }

    @Nonnull
    public static <T extends Execution> Matcher<T> throwsExceptionWithMessage(@Nonnull Class<? extends Throwable> type, @Nullable String messagePattern) {
        return ThrowsException.throwsExceptionWithMessage(type, messagePattern != null ? Pattern.compile(messagePattern) : null);
    }

    protected ThrowsException(@Nonnull Class<? extends Throwable> expectedExceptionType, @Nullable Pattern expectedExceptionMessagePattern) {
        super(Execution.class);
        this.expectedExceptionType = expectedExceptionType;
        this.expectedExceptionMessagePattern = Optional.ofNullable(expectedExceptionMessagePattern);
    }

    protected boolean matchesSafely(@Nonnull T item) {
        Throwable e = this.executionToThrowable.computeIfAbsent((Execution)item, this::executeExecutionAndReturnException);
        if (e == NONE) {
            return false;
        }
        if (this.expectedExceptionType.isInstance(e)) {
            return this.expectedExceptionMessagePattern().map(pattern -> {
                String message = e.getMessage();
                return message != null && pattern.matcher(message).matches();
            }).orElse(true);
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new UndeclaredThrowableException(e);
    }

    @Nonnull
    protected Throwable executeExecutionAndReturnException(@Nonnull Execution execution) {
        try {
            execution.execute();
            return NONE;
        }
        catch (Throwable e) {
            return e;
        }
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText("execution should throw exception of type ").appendValue(this.expectedExceptionType);
        this.expectedExceptionMessagePattern().ifPresent(pattern -> description.appendText(" with message that matches ").appendValue(pattern));
    }

    protected void describeMismatchSafely(@Nonnull T item, @Nonnull Description mismatchDescription) {
        Throwable e = this.executionToThrowable.computeIfAbsent((Execution)item, this::executeExecutionAndReturnException);
        if (e == NONE) {
            mismatchDescription.appendText("throws no exception");
            return;
        }
        this.expectedExceptionMessagePattern().ifPresent(pattern -> {
            String message = e.getMessage();
            if (message == null) {
                mismatchDescription.appendText("message of exception was null");
                return;
            }
            mismatchDescription.appendText("message of exception was ").appendValue((Object)message);
        });
    }

    @Nonnull
    protected Class<? extends Throwable> expectedExceptionType() {
        return this.expectedExceptionType;
    }

    @Nonnull
    protected Optional<Pattern> expectedExceptionMessagePattern() {
        return this.expectedExceptionMessagePattern;
    }

    @FunctionalInterface
    public static interface Execution {
        public void execute() throws Throwable;
    }
}

