/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.unittest.utils.utils.SizeUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class WhereValueOf<T, ST>
extends BaseMatcher<T> {
    @Nonnull
    private final Function<T, ST> mapper;
    @Nullable
    private final String mapperDescription;
    @Nonnull
    private final Matcher<ST> subMatcher;

    @Nonnull
    public static <T, ST> Matcher<T> whereValueOf(@Nonnull Function<T, ST> mapper, @Nonnull String mapperDescription, @Nonnull Matcher<ST> subMatcher) {
        return new WhereValueOf<T, ST>(mapper, mapperDescription, subMatcher);
    }

    @Nonnull
    public static <T, ST> Matcher<T> element(@Nonnull Function<T, ST> mapper, @Nonnull String mapperDescription, @Nonnull Matcher<ST> subMatcher) {
        return WhereValueOf.whereValueOf(mapper, mapperDescription, subMatcher);
    }

    @Nonnull
    public static <T, ST> Matcher<T> elementMatches(@Nonnull Function<T, ST> mapper, @Nonnull String mapperDescription, @Nonnull Matcher<ST> subMatcher) {
        return WhereValueOf.whereValueOf(mapper, mapperDescription, subMatcher);
    }

    @Nonnull
    public static <T, ST> Matcher<T> valueOfMatches(@Nonnull Function<T, ST> mapper, @Nonnull String mapperDescription, @Nonnull Matcher<ST> subMatcher) {
        return WhereValueOf.whereValueOf(mapper, mapperDescription, subMatcher);
    }

    protected WhereValueOf(@Nonnull Function<T, ST> mapper, @Nullable String mapperDescription, @Nonnull Matcher<ST> subMatcher) {
        this.mapper = Objects.requireNonNull(mapper, "No mapper provided.");
        this.mapperDescription = mapperDescription;
        this.subMatcher = Objects.requireNonNull(subMatcher, "No sub matcher provided.");
    }

    public boolean matches(@Nullable Object item) {
        ST subItem;
        try {
            subItem = this.mapper().apply(item);
        }
        catch (ClassCastException ignored) {
            return false;
        }
        return this.subMatcher().matches(subItem);
    }

    public void describeTo(@Nonnull Description description) {
        String mapperDescription = this.mapperDescription();
        description.appendText("where value of ").appendValue(SizeUtils.isNotEmpty(mapperDescription) ? mapperDescription : this.mapper()).appendText(" ");
        this.subMatcher().describeTo(description);
    }

    public void describeMismatch(@Nullable Object item, @Nonnull Description description) {
        ST subItem;
        try {
            subItem = this.mapper().apply(item);
        }
        catch (ClassCastException ignored) {
            description.appendText("was unexpected type ").appendValue(item.getClass());
            return;
        }
        this.subMatcher().describeMismatch(subItem, description);
    }

    @Nonnull
    protected Function<T, ST> mapper() {
        return this.mapper;
    }

    @Nullable
    protected String mapperDescription() {
        return this.mapperDescription;
    }

    @Nonnull
    protected Matcher<ST> subMatcher() {
        return this.subMatcher;
    }
}

