/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.rules;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.unittest.utils.nio.WrappedPath;
import org.echocat.unittest.utils.rules.TemporaryDirectoryBasedRuleSupport;
import org.echocat.unittest.utils.utils.IOUtils;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestFile
extends TemporaryDirectoryBasedRuleSupport<TestFile>
implements WrappedPath {
    @Nonnull
    private static final Random RANDOM = new Random();
    @Nonnull
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @Nonnull
    private final String name;
    @Nullable
    private final ContentProducer contentProducer;
    @Nullable
    private Path wrapped;

    public TestFile(@Nonnull String name) {
        this(name, (ContentProducer)null);
    }

    public TestFile(@Nonnull String name, @Nullable String content) {
        this(name, content != null ? content.getBytes(UTF8) : null);
    }

    public TestFile(@Nonnull String name, @Nullable byte[] content) {
        this(name, content != null ? outputStream -> outputStream.write(content) : null);
    }

    public TestFile(@Nonnull String name, @Nullable ContentProducer contentProducer) {
        this.name = Objects.requireNonNull(name);
        this.contentProducer = contentProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void evaluate(@Nonnull Statement base, @Nonnull Description description, @Nonnull Path baseDirectory) throws Throwable {
        this.wrapped = this.generateFileFor(baseDirectory);
        try {
            base.evaluate();
        }
        finally {
            this.wrapped = null;
        }
    }

    @Override
    @Nonnull
    public Path wrapped() {
        return Objects.requireNonNull(this.wrapped, "Method was not called within test evaluation or @Rule/@ClassRule was missing at field.");
    }

    @Nonnull
    protected Path generateFileFor(@Nonnull Path baseDirectory) throws Exception {
        Path result = baseDirectory.resolve(this.name);
        try (OutputStream os = Files.newOutputStream(result, new OpenOption[0]);){
            if (this.contentProducer != null) {
                this.contentProducer.produce(os);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return this.wrapped().toString();
    }

    @Nonnull
    public static ContentProducer withGeneratedContent(@Nonnegative long numberOfBytes) {
        return os -> {
            long toWrite;
            byte[] buf = new byte[4096];
            for (long written = 0L; written < numberOfBytes; written += toWrite) {
                RANDOM.nextBytes(buf);
                long rest = numberOfBytes - written;
                toWrite = (long)buf.length > rest ? rest : (long)buf.length;
                os.write(buf, 0, (int)toWrite);
            }
        };
    }

    @Nonnull
    public static ContentProducer fromClasspath(@Nonnull String name, @Nonnull Class<?> ofClass) {
        return os -> {
            try (InputStream is = ofClass.getResourceAsStream(name);){
                IOUtils.copy(is, os);
            }
        };
    }

    @Nonnull
    public static ContentProducer fromClasspath(@Nonnull String path, @Nonnull ClassLoader ofClassLoader) {
        return os -> {
            try (InputStream is = ofClassLoader.getResourceAsStream(path);){
                IOUtils.copy(is, os);
            }
        };
    }

    @Nonnull
    public static ContentProducer fromClasspath(@Nonnull String path) {
        return TestFile.fromClasspath(path, Thread.currentThread().getContextClassLoader());
    }

    @FunctionalInterface
    public static interface ContentProducer {
        public void produce(@Nonnull OutputStream var1) throws Exception;
    }
}

