/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.components.engine.python;

import java.io.File;
import java.nio.file.Path;
import org.eclipse.dirigible.components.base.endpoint.BaseEndpoint;
import org.eclipse.dirigible.components.engine.python.graalium.GraalPyCodeRunner;
import org.eclipse.dirigible.graalium.core.graal.ValueTransformer;
import org.eclipse.dirigible.graalium.core.modules.DirigibleSourceProvider;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryNotFoundException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"services/py", "public/py"})
public class PythonEndpoint
extends BaseEndpoint {
    private static final String PYTHON = ".py/";
    private static final Logger logger = LoggerFactory.getLogger((String)PythonEndpoint.class.getCanonicalName());
    private static final String HTTP_PATH_MATCHER = "/{projectName}/{*projectFilePath}";
    private final IRepository repository;

    @Autowired
    public PythonEndpoint(IRepository repository) {
        this.repository = repository;
    }

    @GetMapping(value={"/{projectName}/{*projectFilePath}"})
    public ResponseEntity<?> get(@PathVariable(value="projectName") String projectName, @PathVariable(value="projectFilePath") String projectFilePath, @Nullable @RequestParam(required=false) MultiValueMap<String, String> params) {
        return this.executePython(projectName, projectFilePath, params, null);
    }

    @PostMapping(value={"/{projectName}/{*projectFilePath}"})
    public ResponseEntity<?> post(@PathVariable(value="projectName") String projectName, @PathVariable(value="projectFilePath") String projectFilePath, @Nullable @RequestParam(required=false) MultiValueMap<String, String> params) {
        return this.executePython(projectName, projectFilePath, params, null);
    }

    @PostMapping(value={"/{projectName}/{*projectFilePath}"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> postFile(@PathVariable(value="projectName") String projectName, @PathVariable(value="projectFilePath") String projectFilePath, @Nullable @RequestParam(required=false) MultiValueMap<String, String> params, @Validated @RequestParam(value="file") MultipartFile[] file) {
        return this.executePython(projectName, projectFilePath, params, file);
    }

    @PutMapping(value={"/{projectName}/{*projectFilePath}"})
    public ResponseEntity<?> put(@PathVariable(value="projectName") String projectName, @PathVariable(value="projectFilePath") String projectFilePath, @Nullable @RequestParam(required=false) MultiValueMap<String, String> params) {
        return this.executePython(projectName, projectFilePath, params, null);
    }

    @PutMapping(value={"/{projectName}/{*projectFilePath}"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> putFile(@PathVariable(value="projectName") String projectName, @PathVariable(value="projectFilePath") String projectFilePath, @Nullable @RequestParam(required=false) MultiValueMap<String, String> params, @Validated @RequestParam(value="file") MultipartFile file) {
        return this.executePython(projectName, projectFilePath, params, new MultipartFile[]{file});
    }

    @PatchMapping(value={"/{projectName}/{*projectFilePath}"})
    public ResponseEntity<?> patch(@PathVariable(value="projectName") String projectName, @PathVariable(value="projectFilePath") String projectFilePath, @Nullable @RequestParam(required=false) MultiValueMap<String, String> params) {
        return this.executePython(projectName, projectFilePath, params, null);
    }

    @DeleteMapping(value={"/{projectName}/{*projectFilePath}"})
    public ResponseEntity<?> delete(@PathVariable(value="projectName") String projectName, @PathVariable(value="projectFilePath") String projectFilePath, @Nullable @RequestParam(required=false) MultiValueMap<String, String> params) {
        return this.executePython(projectName, projectFilePath, params, null);
    }

    protected String extractProjectFilePath(String projectFilePath) {
        if (projectFilePath.indexOf(PYTHON) > 0) {
            projectFilePath = projectFilePath.substring(0, projectFilePath.indexOf(PYTHON) + PYTHON.length() + 1);
        }
        return projectFilePath;
    }

    protected String extractPathParam(String projectFilePath) {
        String projectFilePathParam = "";
        if (projectFilePath.indexOf(PYTHON) > 0) {
            projectFilePathParam = projectFilePath.substring(projectFilePath.indexOf(PYTHON) + PYTHON.length() + 1);
        }
        return projectFilePathParam;
    }

    private ResponseEntity<?> executePython(String projectName, String projectFilePath, MultiValueMap<String, String> params, MultipartFile[] files) {
        String projectFilePathParam = this.extractPathParam(projectFilePath);
        projectFilePath = this.extractProjectFilePath(projectFilePath);
        return this.executePython(projectName, projectFilePath, projectFilePathParam, params, files);
    }

    protected ResponseEntity<?> executePython(String projectName, String projectFilePath, String projectFilePathParam, MultiValueMap<String, String> params, MultipartFile[] files) {
        try {
            if (this.isNotValid(projectName) || this.isNotValid(projectFilePath)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            Object result = this.handleRequest(projectName, this.normalizePath(projectFilePath), this.normalizePath(projectFilePathParam), params.get((Object)"debug") != null);
            return ResponseEntity.ok((Object)result);
        }
        catch (RepositoryNotFoundException e) {
            String message = e.getMessage() + ". Try to publish the service before execution.";
            throw new RepositoryNotFoundException(message, (Throwable)e);
        }
    }

    private Object handleRequest(String projectName, String projectFilePath, String projectFilePathParam, boolean debug) {
        Path absoluteSourcePath = PythonEndpoint.getAbsolutePathIfValidProjectFile(projectName, projectFilePath);
        Path workingDir = this.getDirigibleWorkingDirectory();
        Path projectDir = workingDir.resolve(projectName);
        Path pythonMods = this.getDirigiblePythonModulesDirectory();
        try (GraalPyCodeRunner runner = new GraalPyCodeRunner(workingDir, projectDir, pythonMods, debug);){
            Source source = runner.prepareSource(absoluteSourcePath);
            Value value = runner.run(source);
            Object object = ValueTransformer.transformValue((Value)value);
            return object;
        }
    }

    private static Path getAbsolutePathIfValidProjectFile(String projectName, String projectFilePath) {
        DirigibleSourceProvider sourceProvider = new DirigibleSourceProvider();
        String sourceFilePath = Path.of(projectName, projectFilePath).toString();
        String maybePythonCode = sourceProvider.getSource(sourceFilePath);
        if (maybePythonCode == null) {
            throw new RuntimeException("Python source code for project name '" + projectName + "' and file name '" + projectFilePath + "' could not be found, consider publishing it.");
        }
        return sourceProvider.getAbsoluteSourcePath(projectName, projectFilePath);
    }

    private boolean isNotValid(String inputPath) {
        String registryPath = this.getDirigibleWorkingDirectory().toString();
        String normalizedInputPath = Path.of(inputPath, new String[0]).normalize().toString();
        File file = new File(registryPath, normalizedInputPath);
        try {
            return !file.toPath().normalize().startsWith(registryPath);
        }
        catch (Exception e) {
            return true;
        }
    }

    private Path getDirigibleWorkingDirectory() {
        String publicRegistryPath = this.repository.getInternalResourcePath("/registry/public");
        return Path.of(publicRegistryPath, new String[0]);
    }

    private Path getDirigiblePythonModulesDirectory() {
        String publicRegistryPath = this.repository.getInternalResourcePath("/registry/public");
        return Path.of(publicRegistryPath, new String[0]).resolve("python-modules");
    }

    private String normalizePath(String path) {
        if (path != null && path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }
}

