/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.components.engine.python.graalium;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;

public class GraalPyFileSystem
implements org.graalvm.polyglot.io.FileSystem {
    private final FileSystemProvider delegateFileSystemProvider;
    private Path currentWorkingDirectoryPath;

    public GraalPyFileSystem(Path currentWorkingDirectoryPath, FileSystem delegateFileSystem) {
        this.currentWorkingDirectoryPath = currentWorkingDirectoryPath;
        this.delegateFileSystemProvider = delegateFileSystem.provider();
    }

    public Path parsePath(URI uri) {
        throw new RuntimeException("Importing modules from URIs not supported for now.");
    }

    public Path parsePath(String path) {
        if ("".equals(path)) {
            return this.currentWorkingDirectoryPath;
        }
        return Path.of(path, new String[0]);
    }

    public Path toAbsolutePath(Path path) {
        return path.toAbsolutePath();
    }

    public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
        if (path.isAbsolute() && !path.startsWith(this.currentWorkingDirectoryPath)) {
            path = this.currentWorkingDirectoryPath.resolve(path.toString().substring(1));
        }
        return path.toRealPath(linkOptions);
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.delegateFileSystemProvider.newByteChannel(path, options, attrs);
    }

    public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
        if (GraalPyFileSystem.isFollowLinks(linkOptions)) {
            this.delegateFileSystemProvider.checkAccess(path, modes.toArray(new AccessMode[0]));
        } else if (modes.isEmpty()) {
            this.delegateFileSystemProvider.readAttributes(path, "isRegularFile", LinkOption.NOFOLLOW_LINKS);
        } else {
            throw new UnsupportedOperationException("CheckAccess for NIO Provider is unsupported with non empty AccessMode and NOFOLLOW_LINKS.");
        }
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.delegateFileSystemProvider.createDirectory(dir, attrs);
    }

    public void delete(Path path) throws IOException {
        this.delegateFileSystemProvider.delete(path);
    }

    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.delegateFileSystemProvider.copy(source, target, options);
    }

    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.delegateFileSystemProvider.move(source, target, options);
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.delegateFileSystemProvider.newDirectoryStream(dir, filter);
    }

    public void createLink(Path link, Path existing) throws IOException {
        this.delegateFileSystemProvider.createLink(link, existing);
    }

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.delegateFileSystemProvider.createSymbolicLink(link, target, attrs);
    }

    public Path readSymbolicLink(Path link) throws IOException {
        return this.delegateFileSystemProvider.readSymbolicLink(link);
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.delegateFileSystemProvider.readAttributes(path, attributes, options);
    }

    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.delegateFileSystemProvider.setAttribute(path, attribute, value, options);
    }

    public void setCurrentWorkingDirectory(Path currentWorkingDirectoryPath) {
        this.currentWorkingDirectoryPath = currentWorkingDirectoryPath;
    }

    private static boolean isFollowLinks(LinkOption ... linkOptions) {
        for (LinkOption lo : linkOptions) {
            if (lo != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
        return this.delegateFileSystemProvider.isSameFile(path1, path2);
    }

    public Path getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir")).toPath();
    }
}

