/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.components.engine.python.graalium;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.eclipse.dirigible.components.engine.python.graalium.GraalPyFileSystem;
import org.eclipse.dirigible.graalium.core.CodeRunner;
import org.eclipse.dirigible.graalium.core.graal.ContextCreator;
import org.eclipse.dirigible.graalium.core.graal.EngineCreator;
import org.eclipse.dirigible.graalium.core.python.PythonCodeRunner;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.io.FileSystem;

public class GraalPyCodeRunner
implements CodeRunner<Source, Value>,
PythonCodeRunner {
    private final Context context;

    public GraalPyCodeRunner(Path workingDirectoryPath, Path projectDirectoryPath, Path pythonModulesPath, boolean debug) {
        Engine engine = debug ? EngineCreator.getOrCreateDebuggableEngine() : EngineCreator.getOrCreateEngine();
        GraalPyFileSystem fs = new GraalPyFileSystem(workingDirectoryPath, FileSystems.getDefault());
        this.context = new ContextCreator(engine, workingDirectoryPath, projectDirectoryPath, pythonModulesPath, (FileSystem)fs).createContext();
    }

    public Source prepareSource(Path codeFilePath) {
        try {
            return Source.newBuilder((String)"python", (File)codeFilePath.toFile()).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Value run(Source codeSource) {
        return this.context.eval(codeSource);
    }

    public void close() {
        this.context.close();
    }
}

