/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.api;

import org.eclipse.dirigible.api.v3.http.HttpResponseFacade;
import org.eclipse.dirigible.engine.api.script.AbstractScriptExecutor;
import org.eclipse.dirigible.engine.js.api.IJavascriptEngineExecutor;
import org.eclipse.dirigible.engine.js.api.ResourcePath;

public abstract class AbstractJavascriptExecutor
extends AbstractScriptExecutor
implements IJavascriptEngineExecutor {
    public static final String MODULE_EXT_JS = ".js/";
    public static final String MODULE_EXT_RHINO = ".rhino/";
    public static final String MODULE_EXT_NASHORN = ".nashorn/";
    public static final String MODULE_EXT_V8 = ".v8/";

    protected void forceFlush() {
        try {
            if (HttpResponseFacade.isValid()) {
                HttpResponseFacade.flush();
                HttpResponseFacade.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ResourcePath getResourcePath(String module, String ... moduleExtensions) {
        return AbstractJavascriptExecutor.generateResourcePath(module, moduleExtensions);
    }

    public static ResourcePath generateResourcePath(String module, String[] moduleExtensions) {
        for (String moduleExtension : moduleExtensions) {
            if (module.indexOf(moduleExtension) <= 0) continue;
            ResourcePath resourcePath = new ResourcePath();
            String modulePath = module.substring(0, module.indexOf(moduleExtension) + moduleExtension.length() - 1);
            resourcePath.setModule(modulePath);
            if (module.length() > modulePath.length()) {
                resourcePath.setPath(module.substring(modulePath.length() + 1));
            } else {
                resourcePath.setPath("");
            }
            return resourcePath;
        }
        return new ResourcePath(module, "");
    }
}

