/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.processor;

import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.dirigible.commons.api.module.StaticInjector;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.engine.js.api.AbstractJavascriptExecutor;
import org.eclipse.dirigible.engine.js.api.IJavascriptEngineExecutor;

public class DefaultJavascriptEngineExecutor
extends AbstractJavascriptExecutor
implements IJavascriptEngineExecutor {
    private static final ServiceLoader<IJavascriptEngineExecutor> JAVASCRIPT_ENGINE_EXECUTORS = ServiceLoader.load(IJavascriptEngineExecutor.class);
    public static final String ENGINE_NAME = "Default JavaScript Engine";

    public String getType() {
        return "javascript";
    }

    public String getName() {
        return ENGINE_NAME;
    }

    @Override
    public Object executeServiceModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        String javascriptEngineType = Configuration.get((String)"DIRIGIBLE_JAVASCRIPT_ENGINE_TYPE_DEFAULT", (String)"rhino");
        for (IJavascriptEngineExecutor next : JAVASCRIPT_ENGINE_EXECUTORS) {
            if (!next.getType().equals(javascriptEngineType)) continue;
            return ((IJavascriptEngineExecutor)StaticInjector.getInjector().getInstance(next.getClass())).executeServiceModule(module, executionContext);
        }
        throw new ScriptingException("No Javascript Engine registered");
    }

    public Object executeServiceCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        String javascriptEngineType = Configuration.get((String)"DIRIGIBLE_JAVASCRIPT_ENGINE_TYPE_DEFAULT", (String)"rhino");
        for (IJavascriptEngineExecutor next : JAVASCRIPT_ENGINE_EXECUTORS) {
            if (!next.getType().equals(javascriptEngineType)) continue;
            return ((IJavascriptEngineExecutor)StaticInjector.getInjector().getInstance(next.getClass())).executeServiceCode(code, executionContext);
        }
        throw new ScriptingException("No Javascript Engine registered");
    }
}

