/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.auth.basic;

import java.util.List;
import org.eclipse.edc.api.auth.basic.BasicAuthenticationService;
import org.eclipse.edc.api.auth.basic.ConfigCredentials;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.api.auth.spi.registry.ApiAuthenticationRegistry;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;

@Provides(value={AuthenticationService.class})
@Extension(value="Basic authentication")
@Deprecated(since="0.6.5")
public class BasicAuthenticationExtension
implements ServiceExtension {
    @Setting(value="Key-value object defining authentication credentials stored in the vault", type="map", required=true)
    static final String BASIC_AUTH = "edc.api.auth.basic.vault-keys";
    @Inject
    private Vault vault;
    @Inject
    private ApiAuthenticationRegistry authenticationRegistry;

    public void initialize(ServiceExtensionContext context) {
        Monitor monitor = context.getMonitor();
        monitor.warning("The 'auth-basic' module has been deprecated and it will removed in the next iterations.", new Throwable[0]);
        List<ConfigCredentials> credentials = context.getConfig(BASIC_AUTH).getRelativeEntries().entrySet().stream().map(entry -> new ConfigCredentials((String)entry.getKey(), (String)entry.getValue())).toList();
        if (!credentials.isEmpty()) {
            BasicAuthenticationService authService = new BasicAuthenticationService(this.vault, credentials, monitor);
            this.authenticationRegistry.register("management-api", (AuthenticationService)authService);
            monitor.info(String.format("API Authentication: basic auth configured with %s credential(s)", credentials.size()), new Throwable[0]);
        } else {
            monitor.warning("API Authentication: no basic auth credentials provided", new Throwable[0]);
        }
    }
}

