/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.api.auth.basic;

import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.edc.api.auth.basic.ConfigCredentials;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;

public class BasicAuthenticationService
implements AuthenticationService {
    private static final String BASIC_AUTH_HEADER_NAME = "Authorization";
    private final Base64.Decoder b64Decoder;
    private final Vault vault;
    private final List<ConfigCredentials> basicAuthUsersWithVaultKeyConfigs;
    private final Monitor monitor;

    BasicAuthenticationService(Vault vault, List<ConfigCredentials> basicAuthUsersWithVaultKeyConfigs, Monitor monitor) {
        this.vault = vault;
        this.basicAuthUsersWithVaultKeyConfigs = basicAuthUsersWithVaultKeyConfigs;
        this.monitor = monitor;
        this.b64Decoder = Base64.getDecoder();
    }

    public boolean isAuthenticated(Map<String, List<String>> headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.keySet().stream().filter(k -> k.equalsIgnoreCase(BASIC_AUTH_HEADER_NAME)).map(headers::get).filter(list -> !list.isEmpty()).anyMatch(list -> list.stream().map(this::decodeAuthHeader).anyMatch(this::checkBasicAuthValid));
    }

    private Result<BasicAuthCredentials> decodeAuthHeader(String authHeader) {
        String[] authCredentials;
        String[] separatedAuthHeader = authHeader.split(" ");
        if (separatedAuthHeader.length != 2) {
            return Result.failure((String)"Authorization header value is not a valid Bearer token");
        }
        try {
            authCredentials = new String(this.b64Decoder.decode(separatedAuthHeader[1])).split(":");
        }
        catch (IllegalArgumentException ex) {
            return Result.failure((String)"Authorization header could no base64 decoded");
        }
        if (authCredentials.length != 2) {
            return Result.failure((String)"Authorization header could be base64 decoded but is not in format of 'username:password'");
        }
        return Result.success((Object)new BasicAuthCredentials(authCredentials[0], authCredentials[1]));
    }

    private boolean checkBasicAuthValid(Result<BasicAuthCredentials> authCredentials) {
        if (authCredentials.failed()) {
            authCredentials.getFailureMessages().forEach(x$0 -> this.monitor.debug(x$0, new Throwable[0]));
            return false;
        }
        BasicAuthCredentials creds = (BasicAuthCredentials)authCredentials.getContent();
        return this.basicAuthUsersWithVaultKeyConfigs.stream().anyMatch(it -> it.username().equals(creds.username) && Objects.equals(this.vault.resolveSecret(it.vaultKey()), creds.password));
    }

    static class BasicAuthCredentials {
        String username;
        String password;

        BasicAuthCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

