/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.Construct;
import org.eclipse.steady.ConstructId;
import org.eclipse.steady.DirAnalyzer;
import org.eclipse.steady.FileAnalysisException;
import org.eclipse.steady.FileAnalyzer;
import org.eclipse.steady.python.Python335FileAnalyzer;
import org.eclipse.steady.python.Python3FileAnalyzer;
import org.eclipse.steady.python.PythonFileAnalyzer;
import org.eclipse.steady.python.PythonId;
import org.eclipse.steady.shared.enums.DigestAlgorithm;
import org.eclipse.steady.shared.enums.ProgrammingLanguage;
import org.eclipse.steady.shared.json.model.Library;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.StringUtil;

public class PythonArchiveAnalyzer
implements FileAnalyzer {
    private static final Logger log = LogManager.getLogger();
    Map<ConstructId, Construct> constructs = new TreeMap<ConstructId, Construct>();
    private File archive = null;
    private Set<FileAnalyzer> nestedAnalyzers = new HashSet<FileAnalyzer>();

    public String[] getSupportedFileExtensions() {
        return new String[]{"egg", "whl", "gz"};
    }

    public boolean canAnalyze(File _file) {
        String ext = FileUtil.getFileExtension((File)_file);
        if (ext == null || ext.equals("")) {
            return false;
        }
        if (ext.equals("gz") && !_file.getAbsolutePath().endsWith("tar.gz")) {
            return false;
        }
        for (String supported_ext : this.getSupportedFileExtensions()) {
            if (!supported_ext.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    public void analyze(File _file) {
        this.archive = _file;
    }

    public Path getArchivePath() {
        return this.archive != null ? this.archive.toPath() : null;
    }

    public String getDigest() {
        return this.archive != null ? FileUtil.getDigest((File)this.archive, (DigestAlgorithm)DigestAlgorithm.MD5) : null;
    }

    private InputStream getArchiveInputStream() throws IOException {
        ZipInputStream is = null;
        try {
            if (FileUtil.isZipped((File)this.archive).booleanValue()) {
                is = new ZipInputStream(new FileInputStream(this.archive));
            } else {
                GzipCompressorInputStream gzis = new GzipCompressorInputStream((InputStream)new FileInputStream(this.archive));
                is = new TarArchiveInputStream((InputStream)gzis);
            }
        }
        catch (FileNotFoundException e) {
            log.error("Cannot find Pyhton archive to analyze [" + this.archive.getAbsolutePath() + "]", (Throwable)e);
        }
        return is;
    }

    private String getModuleName(String _name) {
        if (_name.lastIndexOf("/") > -1) {
            String module_name_with_ext = _name.substring(_name.lastIndexOf("/") + 1, _name.length());
            return module_name_with_ext.substring(0, module_name_with_ext.indexOf("."));
        }
        return _name.substring(0, _name.indexOf("."));
    }

    private List<String> getPackageName(String _name, List<String> _inits) {
        ArrayList<String> package_name = new ArrayList<String>();
        if (_name.lastIndexOf("/") > -1) {
            String packToFind = _name.substring(0, _name.lastIndexOf("/"));
            while (_inits.contains(packToFind.concat("/__init__.py"))) {
                if (packToFind.lastIndexOf("/") > -1) {
                    package_name.add(0, packToFind.substring(packToFind.lastIndexOf("/") + 1, packToFind.length()));
                    packToFind = packToFind.substring(0, packToFind.lastIndexOf("/"));
                    continue;
                }
                package_name.add(0, packToFind);
                break;
            }
        }
        return package_name;
    }

    private Boolean isPackage(String _en) {
        return _en.endsWith("__init__.py");
    }

    public Map<ConstructId, Construct> getConstructs() throws FileAnalysisException {
        if (this.constructs.isEmpty()) {
            ZipEntry en;
            InputStream is;
            ArrayList<String> inits = new ArrayList<String>();
            boolean pre_processed = false;
            try {
                is = this.getArchiveInputStream();
                try {
                    if (is instanceof ZipInputStream) {
                        en = null;
                        while ((en = ((ZipInputStream)is).getNextEntry()) != null) {
                            if (en.isDirectory() || !this.isPackage(en.getName()).booleanValue()) continue;
                            inits.add(en.getName());
                        }
                    } else if (is instanceof TarArchiveInputStream) {
                        en = null;
                        while ((en = ((TarArchiveInputStream)is).getNextEntry()) != null) {
                            if (en.isDirectory() || !this.isPackage(en.getName()).booleanValue()) continue;
                            inits.add(en.getName());
                        }
                    }
                    pre_processed = true;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                log.error("IOException analyzing Python archive [" + this.archive.getAbsolutePath() + "]", (Throwable)e);
            }
            try {
                is = this.getArchiveInputStream();
                try {
                    if (is instanceof ZipInputStream && pre_processed) {
                        en = null;
                        while ((en = ((ZipInputStream)is).getNextEntry()) != null) {
                            if (en.isDirectory()) continue;
                            if (en.getName().endsWith(".whl") || en.getName().endsWith(".egg") || en.getName().endsWith(".gz")) {
                                FileAnalyzer fa = DirAnalyzer.createAnalyzerForArchiveEntry((InputStream)is, (String)en.getName());
                                if (fa == null) continue;
                                this.nestedAnalyzers.add(fa);
                                continue;
                            }
                            if (!en.getName().endsWith(".py")) continue;
                            List<String> package_name = this.getPackageName(en.getName(), inits);
                            PythonId pack = null;
                            if (!package_name.isEmpty()) {
                                pack = new PythonId(null, PythonId.Type.PACKAGE, StringUtil.join(package_name, (String)"."));
                            }
                            String module_name = this.getModuleName(en.getName());
                            PythonId module = new PythonId(pack, PythonId.Type.MODULE, module_name);
                            byte[] py_bytes = FileUtil.readInputStream((InputStream)is);
                            FileAnalyzer fa = PythonFileAnalyzer.createAnalyzer(new ByteArrayInputStream(py_bytes));
                            if (fa instanceof Python3FileAnalyzer) {
                                ((Python3FileAnalyzer)fa).setContext(module, pack);
                                this.constructs.putAll(((Python3FileAnalyzer)fa).getConstructs(new ByteArrayInputStream(py_bytes)));
                                continue;
                            }
                            if (!(fa instanceof Python335FileAnalyzer)) continue;
                            ((Python335FileAnalyzer)fa).setContext(module, pack);
                            this.constructs.putAll(((Python335FileAnalyzer)fa).getConstructs(new ByteArrayInputStream(py_bytes)));
                        }
                    } else if (is instanceof TarArchiveInputStream) {
                        en = null;
                        while ((en = ((TarArchiveInputStream)is).getNextEntry()) != null) {
                            if (en.isDirectory()) continue;
                            if (en.getName().endsWith(".whl") || en.getName().endsWith(".egg") || en.getName().endsWith(".gz")) {
                                FileAnalyzer fa = DirAnalyzer.createAnalyzerForArchiveEntry((InputStream)is, (String)en.getName());
                                if (fa == null) continue;
                                this.nestedAnalyzers.add(fa);
                                continue;
                            }
                            if (!en.getName().endsWith(".py")) continue;
                            List<String> package_name = this.getPackageName(en.getName(), inits);
                            PythonId pack = null;
                            if (!package_name.isEmpty()) {
                                pack = new PythonId(null, PythonId.Type.PACKAGE, StringUtil.join(package_name, (String)"."));
                            }
                            String module_name = this.getModuleName(en.getName());
                            PythonId module = new PythonId(pack, PythonId.Type.MODULE, module_name);
                            byte[] py_bytes = FileUtil.readInputStream((InputStream)is);
                            FileAnalyzer fa = PythonFileAnalyzer.createAnalyzer(new ByteArrayInputStream(py_bytes));
                            if (fa instanceof Python3FileAnalyzer) {
                                ((Python3FileAnalyzer)fa).setContext(module, pack);
                                this.constructs.putAll(((Python3FileAnalyzer)fa).getConstructs(new ByteArrayInputStream(py_bytes)));
                                continue;
                            }
                            if (!(fa instanceof Python335FileAnalyzer)) continue;
                            ((Python335FileAnalyzer)fa).setContext(module, pack);
                            this.constructs.putAll(((Python335FileAnalyzer)fa).getConstructs(new ByteArrayInputStream(py_bytes)));
                        }
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                log.error("IOException analyzing Python archive [" + this.archive.getAbsolutePath() + "]", (Throwable)e);
            }
        }
        return this.constructs;
    }

    public Library getLibrary() throws FileAnalysisException {
        Library lib = new Library();
        if (this.getDigest() != null) {
            lib.setDigest(this.getDigest());
            lib.setDigestAlgorithm(DigestAlgorithm.MD5);
        }
        lib.setConstructs(this.getSharedConstructs());
        return lib;
    }

    public boolean containsConstruct(ConstructId _id) throws FileAnalysisException {
        return this.constructs.containsKey(_id);
    }

    public Construct getConstruct(ConstructId _id) throws FileAnalysisException {
        return this.constructs.get(_id);
    }

    public boolean hasChilds() {
        return this.nestedAnalyzers != null && !this.nestedAnalyzers.isEmpty();
    }

    public Set<FileAnalyzer> getChilds(boolean _recursive) {
        HashSet<FileAnalyzer> nested_fa = new HashSet<FileAnalyzer>();
        if (!_recursive) {
            nested_fa.addAll(this.nestedAnalyzers);
        } else {
            for (FileAnalyzer fa : this.nestedAnalyzers) {
                nested_fa.add(fa);
                Set nfas = fa.getChilds(true);
                if (nfas == null || nfas.isEmpty()) continue;
                nested_fa.addAll(nfas);
            }
        }
        return nested_fa;
    }

    public List<org.eclipse.steady.shared.json.model.ConstructId> getSharedConstructs() throws FileAnalysisException {
        ArrayList<org.eclipse.steady.shared.json.model.ConstructId> l = new ArrayList<org.eclipse.steady.shared.json.model.ConstructId>();
        for (ConstructId c : this.getConstructs().keySet()) {
            l.add(new org.eclipse.steady.shared.json.model.ConstructId(ProgrammingLanguage.PY, c.getSharedType(), c.getQualifiedName()));
        }
        return l;
    }
}

