/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.Construct;
import org.eclipse.steady.ConstructId;
import org.eclipse.steady.FileAnalysisException;
import org.eclipse.steady.FileAnalyzer;
import org.eclipse.steady.python.Python335FileAnalyzer;
import org.eclipse.steady.python.Python3FileAnalyzer;
import org.eclipse.steady.python.PythonId;
import org.eclipse.steady.shared.util.DirUtil;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.StringUtil;

public class PythonFileAnalyzer
implements FileAnalyzer {
    private static final Logger log = LogManager.getLogger();
    private FileAnalyzer analyzer = null;
    private File file = null;
    private Map<ConstructId, Construct> constructs = null;
    static final Pattern[] PY2_PATTERNS = new Pattern[]{Pattern.compile("^\\s*print\\s+\".*$"), Pattern.compile("^.*raw_input\\(.*$")};
    static final Pattern[] PY35_ASYNC_PATTERNS = new Pattern[]{Pattern.compile("^.*async\\s*def.*$")};
    static final Pattern[] COMMENT_PATTERNS = new Pattern[]{Pattern.compile("^\\s*#.*$")};

    public String[] getSupportedFileExtensions() {
        return new String[]{"py"};
    }

    public boolean canAnalyze(File _file) {
        String ext = FileUtil.getFileExtension((File)_file);
        if (ext == null || ext.equals("")) {
            return false;
        }
        for (String supported_ext : this.getSupportedFileExtensions()) {
            if (!supported_ext.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    public void analyze(File _file) throws FileAnalysisException {
        if (!FileUtil.isAccessibleFile((Path)_file.toPath())) {
            throw new IllegalArgumentException("[" + _file + "] does not exist or is not readable");
        }
        this.file = _file;
    }

    static boolean isTopOfType(Stack<PythonId> _context, PythonId.Type _type) {
        if (_context == null) {
            throw new IllegalArgumentException("Stack argument is null");
        }
        if (_context.isEmpty()) {
            return false;
        }
        PythonId id = _context.peek();
        return id.getType().equals((Object)_type);
    }

    static boolean isTopOfType(Stack<PythonId> _context, PythonId.Type[] _types) {
        if (_context == null) {
            throw new IllegalArgumentException("Stack argument is null");
        }
        if (_context.isEmpty()) {
            return false;
        }
        PythonId id = _context.peek();
        for (PythonId.Type t : _types) {
            if (!id.getType().equals((Object)t)) continue;
            return true;
        }
        return false;
    }

    public Map<ConstructId, Construct> getConstructs() throws FileAnalysisException {
        if (this.constructs == null) {
            this.analyzer = PythonFileAnalyzer.createAnalyzer(this.file);
            this.analyzer.analyze(this.file);
            this.constructs = this.analyzer.getConstructs();
        }
        return this.analyzer.getConstructs();
    }

    public boolean containsConstruct(ConstructId _id) throws FileAnalysisException {
        return this.getConstructs().containsKey(_id);
    }

    public Construct getConstruct(ConstructId _id) throws FileAnalysisException {
        return this.getConstructs().get(_id);
    }

    public boolean hasChilds() {
        return false;
    }

    public Set<FileAnalyzer> getChilds(boolean _recursive) {
        return null;
    }

    public static PythonId getModule(File _file) throws IllegalArgumentException {
        if (!FileUtil.hasFileExtension((Path)_file.toPath(), (String[])new String[]{"py"})) {
            throw new IllegalArgumentException("Expected file with file extension [py], got [" + _file.toString() + "]");
        }
        Path p = _file.toPath().toAbsolutePath();
        String module_name = FileUtil.getFileName((String)p.toString(), (boolean)false);
        ArrayList<String> package_name = new ArrayList<String>();
        Path search_path = p.getParent();
        while (DirUtil.containsFile((File)search_path.toFile(), (String)"__init__.py") && search_path.getNameCount() > 1) {
            package_name.add(0, search_path.getFileName().toString());
            search_path = search_path.getParent();
        }
        PythonId pack = null;
        if (!package_name.isEmpty()) {
            pack = new PythonId(null, PythonId.Type.PACKAGE, StringUtil.join(package_name, (String)"."));
        }
        return new PythonId(pack, PythonId.Type.MODULE, module_name);
    }

    public static FileAnalyzer createAnalyzer(File _file) {
        FileAnalyzer fileAnalyzer;
        FileInputStream is = new FileInputStream(_file);
        try {
            fileAnalyzer = PythonFileAnalyzer.createAnalyzer(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error(e.getClass().getSimpleName() + " when creating analyzer for file [" + _file.toPath().toAbsolutePath() + "]: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        ((InputStream)is).close();
        return fileAnalyzer;
    }

    public static FileAnalyzer createAnalyzer(InputStream _is) throws IOException {
        ParseTreeListener fa = null;
        BufferedReader isr = new BufferedReader(new InputStreamReader(_is));
        String line = null;
        int line_count = 0;
        while ((line = isr.readLine()) != null) {
            ++line_count;
            if (StringUtil.matchesPattern((String)line, (Pattern[])COMMENT_PATTERNS)) continue;
            if (StringUtil.matchesPattern((String)line, (Pattern[])PY2_PATTERNS)) {
                log.info("Found one of the Python 2 patterns [" + StringUtil.join((Object[])PY2_PATTERNS, (String)", ") + "] in line [" + line_count + "]: " + line.trim());
                fa = new Python335FileAnalyzer();
                break;
            }
            if (!StringUtil.matchesPattern((String)line, (Pattern[])PY35_ASYNC_PATTERNS)) continue;
            log.info("Found one of the Python 3.5 patterns [" + StringUtil.join((Object[])PY35_ASYNC_PATTERNS, (String)", ") + "] in line [" + line_count + "]: " + line.trim());
            fa = new Python3FileAnalyzer();
            break;
        }
        if (fa == null) {
            fa = new Python335FileAnalyzer();
        }
        return fa;
    }
}

