/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python.pip;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.Construct;
import org.eclipse.steady.ConstructId;
import org.eclipse.steady.DirAnalyzer;
import org.eclipse.steady.FileAnalysisException;
import org.eclipse.steady.FileAnalyzer;
import org.eclipse.steady.FileAnalyzerFactory;
import org.eclipse.steady.python.PythonArchiveAnalyzer;
import org.eclipse.steady.shared.enums.DigestAlgorithm;
import org.eclipse.steady.shared.enums.PropertySource;
import org.eclipse.steady.shared.json.model.Library;
import org.eclipse.steady.shared.json.model.LibraryId;
import org.eclipse.steady.shared.json.model.Property;
import org.eclipse.steady.shared.util.DirUtil;
import org.eclipse.steady.shared.util.DirnamePatternSearch;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.FilenamePatternSearch;
import org.eclipse.steady.shared.util.StringList;

public class PipInstalledPackage
implements Comparable {
    private static final Logger log = LogManager.getLogger();
    private static final String LOCATION = "Location";
    private static final String REQUIRES = "Requires";
    private String name = null;
    private String version = null;
    private Map<String, String> properties = new HashMap<String, String>();
    private String digest = null;
    private Map<ConstructId, Construct> constructs = null;
    private String downloadUrl = null;
    private Path downloadPath = null;
    private Path eggFile = null;
    private Path pyFile = null;
    private Path pyDir = null;
    private FileAnalyzer fileAnalyzer = null;

    public PipInstalledPackage(String _name, String _version) {
        this.name = _name;
        this.version = _version;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Path getInstallPath() {
        return Paths.get(this.properties.get(LOCATION), new String[0]);
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Path getDownloadPath() {
        return this.downloadPath;
    }

    public void setDownloadPath(Path downloadPath) {
        this.downloadPath = downloadPath;
    }

    public Library getLibrary() throws FileAnalysisException {
        Library lib = null;
        if (this.fileAnalyzer != null && this.fileAnalyzer instanceof PythonArchiveAnalyzer) {
            lib = ((PythonArchiveAnalyzer)this.fileAnalyzer).getLibrary();
            lib.setLibraryId(new LibraryId(this.getName(), this.getName(), this.getVersion()));
        } else {
            lib = new Library();
            lib.setDigest(this.getDigest());
            lib.setDigestAlgorithm(DigestAlgorithm.MD5);
            lib.setLibraryId(new LibraryId(this.getName(), this.getName(), this.getVersion()));
            if (this.getConstructs() != null) {
                lib.setConstructs(ConstructId.getSharedType(this.getConstructs().keySet()));
            }
        }
        HashSet<Property> p = new HashSet<Property>();
        for (String key : this.getProperties().keySet()) {
            p.add(new Property(PropertySource.PIP, key, this.getProperties().get(key)));
        }
        lib.setProperties(p);
        return lib;
    }

    public boolean requires(PipInstalledPackage _pack) throws IllegalStateException {
        if (this.properties == null || !this.properties.containsKey(REQUIRES)) {
            throw new IllegalStateException("Property [Requires] not known");
        }
        String[] packs = this.properties.get(REQUIRES).split(",");
        for (int i = 0; i < packs.length; ++i) {
            if (!_pack.getName().equalsIgnoreCase(packs[i].trim())) continue;
            return true;
        }
        return false;
    }

    public void addProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[").append(this.getName()).append(":").append(this.getVersion()).append("]");
        return b.toString();
    }

    public String getDigest() {
        if (!(this.downloadPath != null || this.properties != null && this.properties.containsKey(LOCATION))) {
            throw new IllegalStateException(this + " does not have local download path nor property [" + LOCATION + "]");
        }
        if (this.digest == null) {
            if (this.downloadPath != null) {
                this.digest = FileUtil.getDigest((File)this.downloadPath.toFile(), (DigestAlgorithm)DigestAlgorithm.MD5);
                log.info("Computed MD5 [" + this.digest + "] from downloaded file [" + this.downloadPath + "]");
            } else {
                this.eggFile = this.searchEgg();
                this.pyFile = this.searchPyFile();
                this.pyDir = this.searchPyDir();
                if (this.eggFile != null) {
                    this.digest = FileUtil.getDigest((File)this.eggFile.toFile(), (DigestAlgorithm)DigestAlgorithm.MD5);
                    log.info("Computed MD5 [" + this.digest + "] from egg file [" + this.eggFile + "]");
                } else if (this.pyFile != null) {
                    this.digest = FileUtil.getDigest((File)this.pyFile.toFile(), (DigestAlgorithm)DigestAlgorithm.MD5);
                    log.info("Computed MD5 [" + this.digest + "] from file [" + this.pyFile + "]");
                } else if (this.pyDir != null) {
                    this.digest = DirUtil.getDigest((File)this.pyDir.toFile(), (String[])new String[]{".pyc"}, (DigestAlgorithm)DigestAlgorithm.MD5);
                    log.info("Computed MD5 [" + this.digest + "] from directory [" + this.pyDir + "]");
                } else {
                    log.error("Cannot compute MD5 of " + this);
                }
            }
        }
        return this.digest;
    }

    private Map<ConstructId, Construct> getConstructs() throws FileAnalysisException {
        if (this.fileAnalyzer == null) {
            if (this.downloadPath != null) {
                this.fileAnalyzer = FileAnalyzerFactory.buildFileAnalyzer((File)this.downloadPath.toFile());
                if (this.fileAnalyzer != null) {
                    this.constructs = this.fileAnalyzer.getConstructs();
                    log.info("Got [" + this.constructs.size() + "] constructs from downloaded file [" + this.downloadPath + "]");
                }
            } else if (this.eggFile != null) {
                this.fileAnalyzer = FileAnalyzerFactory.buildFileAnalyzer((File)this.eggFile.toFile());
                this.constructs = this.fileAnalyzer.getConstructs();
                log.info("Got [" + this.constructs.size() + "] constructs from egg [" + this.eggFile + "]");
            } else if (this.pyFile != null) {
                this.fileAnalyzer = FileAnalyzerFactory.buildFileAnalyzer((File)this.pyFile.toFile());
                this.constructs = this.fileAnalyzer.getConstructs();
                log.info("Got [" + this.constructs.size() + "] constructs from file [" + this.pyFile + "]");
            } else if (this.pyDir != null) {
                this.fileAnalyzer = FileAnalyzerFactory.buildFileAnalyzer((File)this.pyDir.toFile());
                this.constructs = this.fileAnalyzer.getConstructs();
                log.info("Got [" + this.constructs.size() + "] constructs from directory [" + this.pyDir + "]");
            } else {
                log.error("Cannot get constructs of " + this);
            }
        }
        return this.constructs;
    }

    public Set<FileAnalyzer> getNestedArchives() {
        if (this.fileAnalyzer != null && !(this.fileAnalyzer instanceof DirAnalyzer)) {
            return this.fileAnalyzer.getChilds(true);
        }
        return null;
    }

    public int compareTo(Object _other) {
        if (_other instanceof PipInstalledPackage) {
            PipInstalledPackage other = (PipInstalledPackage)_other;
            int i = this.name.compareTo(other.getName());
            if (i == 0) {
                i = this.version.compareTo(other.getVersion());
            }
            return i;
        }
        throw new IllegalArgumentException("Cannot compare with object of type [" + _other.getClass() + "]");
    }

    private Path searchEgg() {
        Path file = null;
        String name = this.getName().replaceAll("-", "_");
        Path location = Paths.get(this.properties.get(LOCATION), new String[0]);
        FilenamePatternSearch fns = new FilenamePatternSearch("^" + name + "-" + this.version + "-.*egg$");
        Set files = fns.search(location, 0);
        if (files.size() == 0) {
            log.info("No egg file found for " + this + " in path [" + location + "]");
        } else if (files.size() == 1) {
            file = (Path)files.iterator().next();
            log.info("Egg file [" + file + "] found for " + this + " in path [" + location + "]");
        } else {
            log.info(files.size() + " egg files found for " + this + " in path [" + location + "]");
        }
        return file;
    }

    private Path searchPyFile() {
        Path file = null;
        String name = this.getName().replaceAll("-", "_");
        Path location = Paths.get(this.properties.get(LOCATION), new String[0]);
        FilenamePatternSearch fns = new FilenamePatternSearch("^" + name + ".py$");
        Set files = fns.search(location, 0);
        if (files.size() == 0) {
            log.info("No python file found for " + this + " in path [" + location + "]");
        } else if (files.size() == 1) {
            file = (Path)files.iterator().next();
            log.info("Python file [" + file + "] found for " + this + " in path [" + location + "]");
        } else {
            log.info(files.size() + " python files found for " + this + " in path [" + location + "]");
        }
        return file;
    }

    private Path searchPyDir() {
        Path file = Paths.get(Paths.get(this.properties.get(LOCATION), new String[0]).toString(), new String[0]);
        if (FileUtil.isAccessibleDirectory((Path)file) && !file.toString().endsWith("site-packages")) {
            return file;
        }
        String name = this.getName().replaceAll("-", "_");
        Path location = Paths.get(this.properties.get(LOCATION), new String[0]);
        DirnamePatternSearch dns = new DirnamePatternSearch("^" + name + "-" + this.version + "-.*egg$");
        Set files = dns.search(location, 0);
        if (files.size() == 0) {
            log.info("No python dir found for " + this + " in path [" + location + "]");
            file = null;
        } else if (files.size() == 1) {
            log.info("Python dir [" + file + "] found for " + this + " in path [" + location + "]");
            file = (Path)files.iterator().next();
        } else {
            log.info(files.size() + " python dirs found for " + this + " in path [" + location + "]");
            file = null;
        }
        return file;
    }

    public static Set<PipInstalledPackage> filterUsingArtifact(Set<PipInstalledPackage> _packages, StringList _filter, boolean _include) {
        HashSet<PipInstalledPackage> r = new HashSet<PipInstalledPackage>();
        for (PipInstalledPackage p : _packages) {
            try {
                if (_include) {
                    if (!_filter.contains(p.getLibrary().getLibraryId().getArtifact())) continue;
                    r.add(p);
                    continue;
                }
                if (_filter.contains(p.getLibrary().getLibraryId().getArtifact())) continue;
                r.add(p);
            }
            catch (FileAnalysisException e) {
                log.error("Error getting library ID of package [" + p + "]: " + e.getMessage(), (Throwable)e);
            }
        }
        return r;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PipInstalledPackage other = (PipInstalledPackage)obj;
        if (this.name == null ? other.name != null : !this.getStandardDistributionName().equals(other.getStandardDistributionName())) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getStandardDistributionName() {
        return PipInstalledPackage.getStandardDistributionName(this.getName());
    }

    public static String getStandardDistributionName(String _name) {
        return _name.toLowerCase().replaceAll("\\p{Punct}", "_");
    }

    public boolean equalsStandardDistributionName(PipInstalledPackage _other) {
        return this.getStandardDistributionName().equals(_other.getStandardDistributionName());
    }
}

