/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python.pip;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.python.ProcessWrapper;
import org.eclipse.steady.python.ProcessWrapperException;
import org.eclipse.steady.python.pip.PipInstalledPackage;
import org.eclipse.steady.shared.json.JacksonUtil;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.StopWatch;
import org.eclipse.steady.shared.util.StringList;
import org.eclipse.steady.shared.util.ThreadUtil;
import org.eclipse.steady.shared.util.VulasConfiguration;

public class PipWrapper {
    private static final Logger log = LogManager.getLogger();
    static final Pattern DOWNLOAD_PATTERN = Pattern.compile("^\\s*Downloading\\s*(http\\S*).*$");
    static final Pattern SAVED_PATTERN_1 = Pattern.compile("^\\s*File was already downloaded\\s*(.*)$");
    static final Pattern SAVED_PATTERN_2 = Pattern.compile("^\\s*Saved\\s*(.*)$");
    static final String PACK_PATTERN_REGEX = ".*<pack>-<version>.*";
    private Path pathToPip = null;
    private Path logDir = null;
    private StringList ignorePacks = new StringList();

    public PipWrapper() throws ProcessWrapperException {
        this(Paths.get("pip", new String[0]), null);
    }

    public PipWrapper(Path _path_to_pip, Path _log_dir) throws ProcessWrapperException {
        this.pathToPip = _path_to_pip;
        if (_log_dir != null) {
            this.logDir = _log_dir;
        } else {
            try {
                this.logDir = FileUtil.createTmpDir((String)"vulas-pip-");
                log.info("Created tmp directory [" + this.logDir + "]");
            }
            catch (IOException e) {
                throw new ProcessWrapperException("Cannot create tmp directory: " + e.getMessage());
            }
        }
        String[] ignore_packs = VulasConfiguration.getGlobal().getStringArray("vulas.core.bom.python.ignorePacks", new String[0]);
        this.ignorePacks.addAll(ignore_packs, true);
    }

    private boolean ignorePackage(String _p) {
        return this.ignorePacks.contains(_p, StringList.ComparisonMode.EQUALS, StringList.CaseSensitivity.CASE_SENSITIVE);
    }

    public boolean isAvailable() {
        boolean exists = false;
        try {
            Process p = new ProcessBuilder(this.pathToPip.toString()).start();
            int exit_code = p.waitFor();
            exists = exit_code == 0;
        }
        catch (IOException ioe) {
            log.error("Error calling [pip]: " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            log.error("Error calling [pip]: " + ie.getMessage(), (Throwable)ie);
        }
        return exists;
    }

    public Set<PipInstalledPackage> installPackages(Path _project) {
        Set<PipInstalledPackage> packages = null;
        try {
            Path download_dir = Paths.get(this.logDir.toString(), "pip-download");
            FileUtil.createDirectory((Path)download_dir);
            ProcessWrapper pw = new ProcessWrapper();
            pw.setCommand(this.pathToPip, "download", "-d", download_dir.toString(), "--no-cache-dir", _project.toString());
            pw.setPath(this.logDir);
            Thread t = new Thread(pw);
            t.start();
            t.join();
            Path download_info = pw.getOutFile();
            pw = new ProcessWrapper();
            pw.setCommand(this.pathToPip, "install", _project.toString());
            pw.setPath(this.logDir);
            t = new Thread(pw);
            t.start();
            t.join();
            packages = this.getListPackages();
            this.searchDownloadInfo(packages, FileUtil.readFile((Path)download_info));
        }
        catch (ProcessWrapperException e) {
            log.error("Error calling installing packages: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error("Error calling installing packages: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("Error calling installing packages: " + e.getMessage(), (Throwable)e);
        }
        return packages;
    }

    public Set<PipInstalledPackage> getFreezePackages() throws ProcessWrapperException, IOException, InterruptedException {
        StopWatch sw = new StopWatch("pip freeze").start();
        Set<PipInstalledPackage> packages = null;
        ProcessWrapper pw = new ProcessWrapper().setCommand(this.pathToPip, "freeze").setPath(this.logDir);
        Thread t = new Thread((Runnable)pw, "pip");
        t.start();
        t.join();
        if (pw.terminatedWithSuccess()) {
            packages = this.parsePipFreezeOutput(pw.getOutFile());
            log.info("Found [" + packages.size() + "] pip packages:");
            for (PipInstalledPackage pack : packages) {
                log.info("    " + pack);
            }
            ExecutorService pool = Executors.newFixedThreadPool(ThreadUtil.getNoThreads((int)2));
            HashSet<Future<PipInstalledPackage>> futures = new HashSet<Future<PipInstalledPackage>>();
            for (PipInstalledPackage pack : packages) {
                futures.add(pool.submit(new PipShow(pack)));
                futures.add(pool.submit(new PipDownload(pack)));
            }
            pool.shutdown();
            try {
                while (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    int done = 0;
                    for (Future future : futures) {
                        if (!future.isDone()) continue;
                        ++done;
                    }
                    sw.lap("[" + done + "/" + futures.size() + "] pip jobs are done");
                }
            }
            catch (InterruptedException e) {
                log.error("Interrupt exception");
            }
        }
        sw.stop();
        return packages;
    }

    private Set<PipInstalledPackage> parsePipFreezeOutput(Path _file) throws IOException {
        String line;
        TreeSet<PipInstalledPackage> packs = new TreeSet<PipInstalledPackage>();
        Pattern pattern = Pattern.compile("^(.*)==(.*)$");
        BufferedReader reader = new BufferedReader(new FileReader(_file.toFile()));
        while ((line = reader.readLine()) != null) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            if (this.ignorePackage(m.group(1))) {
                log.warn("Package [" + m.group(1) + "] not added as installed package");
                continue;
            }
            packs.add(new PipInstalledPackage(m.group(1), m.group(2)));
        }
        reader.close();
        return packs;
    }

    public Set<PipInstalledPackage> getListPackages() throws ProcessWrapperException, IOException, InterruptedException {
        StopWatch sw = new StopWatch("pip list").start();
        ProcessWrapper pw = new ProcessWrapper().setCommand(this.pathToPip, "list", "--format", "legacy").setPath(this.logDir);
        Thread t = new Thread((Runnable)pw, "pip");
        t.start();
        t.join();
        Set<PipInstalledPackage> packages = null;
        if (pw.terminatedWithSuccess()) {
            packages = this.parsePipListOutput(pw.getOutFile());
        } else {
            log.info("Legacy format did not work, trying JSON format...");
            pw = new ProcessWrapper().setCommand(this.pathToPip, "list", "--format", "json").setPath(this.logDir);
            t = new Thread((Runnable)pw, "pip");
            t.start();
            t.join();
            if (pw.terminatedWithSuccess()) {
                packages = this.deserializePipListOutput(pw.getOutFile());
            }
        }
        if (packages != null) {
            log.info("Found [" + packages.size() + "] pip packages:");
            for (PipInstalledPackage pack : packages) {
                log.info("    " + pack);
            }
            ExecutorService pool = Executors.newFixedThreadPool(ThreadUtil.getNoThreads((int)2));
            HashSet<Future<PipInstalledPackage>> futures = new HashSet<Future<PipInstalledPackage>>();
            for (PipInstalledPackage pack : packages) {
                futures.add(pool.submit(new PipShow(pack)));
            }
            pool.shutdown();
            try {
                while (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    int done = 0;
                    for (Future future : futures) {
                        if (!future.isDone()) continue;
                        ++done;
                    }
                    sw.lap("[" + done + "/" + futures.size() + "] pip jobs are done");
                }
            }
            catch (InterruptedException e) {
                log.error("Interrupt exception");
            }
        } else {
            log.warn("No pip packages found with pip list");
        }
        sw.stop();
        return packages;
    }

    private Set<PipInstalledPackage> parsePipListOutput(Path _file) throws IOException {
        String line;
        TreeSet<PipInstalledPackage> packs = new TreeSet<PipInstalledPackage>();
        Pattern pattern_brackets = Pattern.compile("^(.*)\\s+\\((.*)\\)$");
        BufferedReader reader = new BufferedReader(new FileReader(_file.toFile()));
        while ((line = reader.readLine()) != null) {
            Matcher mb = pattern_brackets.matcher(line);
            if (!mb.matches()) continue;
            if (this.ignorePackage(mb.group(1))) {
                log.warn("Package [" + mb.group(1) + "] not added as installed package");
                continue;
            }
            packs.add(new PipInstalledPackage(mb.group(1), mb.group(2)));
        }
        reader.close();
        return packs;
    }

    private Set<PipInstalledPackage> deserializePipListOutput(Path _file) throws IOException {
        String json = FileUtil.readFile((Path)_file);
        PipPackageJson[] packs = (PipPackageJson[])JacksonUtil.asObject((String)json, PipPackageJson[].class);
        HashSet<PipInstalledPackage> set = new HashSet<PipInstalledPackage>();
        for (PipPackageJson p : packs) {
            if (this.ignorePackage(p.getName())) {
                log.warn("Package [" + p.getName() + "] not added as installed package");
                continue;
            }
            set.add(new PipInstalledPackage(p.getName(), p.getVersion()));
        }
        return set;
    }

    private Map<String, String> parsePipShowOutput(Path _file) throws IOException {
        String line;
        HashMap<String, String> props = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("^([^:]*):(.*)$");
        BufferedReader reader = new BufferedReader(new FileReader(_file.toFile()));
        while ((line = reader.readLine()) != null) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            props.put(m.group(1).trim(), m.group(2).trim());
        }
        reader.close();
        return props;
    }

    void searchDownloadInfo(Set<PipInstalledPackage> _packs, String _out) throws IOException {
        if (_packs != null) {
            for (PipInstalledPackage pack : _packs) {
                this.searchDownloadInfo(pack, _out);
            }
        }
    }

    private void searchDownloadInfo(PipInstalledPackage _p, String _out) throws IOException {
        Matcher m;
        HashSet<String> urls = new HashSet<String>();
        HashSet<String> files = new HashSet<String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(_out.getBytes())));
        String line = null;
        while ((line = r.readLine()) != null) {
            Matcher d = DOWNLOAD_PATTERN.matcher(line);
            Matcher s1 = SAVED_PATTERN_1.matcher(line);
            Matcher s2 = SAVED_PATTERN_2.matcher(line);
            if (d.matches()) {
                urls.add(d.group(1));
                continue;
            }
            if (s1.matches()) {
                files.add(s1.group(1));
                continue;
            }
            if (!s2.matches()) continue;
            files.add(s2.group(1));
        }
        String regex = PACK_PATTERN_REGEX.replace("<pack>", _p.getName().toLowerCase());
        regex = regex.replace("<version>", _p.getVersion().toLowerCase());
        regex = regex.replace("-", "[_-]{1,1}");
        Pattern p = Pattern.compile(regex);
        for (String url : urls) {
            m = p.matcher(url.toLowerCase());
            if (!m.matches()) continue;
            _p.setDownloadUrl(url);
            break;
        }
        for (String file : files) {
            m = p.matcher(file.toLowerCase());
            if (!m.matches()) continue;
            _p.setDownloadPath(Paths.get(file, new String[0]));
            break;
        }
        if (_p.getDownloadPath() == null && _p.getDownloadUrl() == null) {
            log.warn("Download path and URL for " + _p + " missing");
        } else if (_p.getDownloadPath() == null) {
            log.warn("Download path for " + _p + " missing");
        } else if (_p.getDownloadUrl() == null) {
            log.warn("Download URL for " + _p + " missing");
        } else {
            log.info("Found download info for " + _p);
        }
    }

    static class PipPackageJson {
        String name;
        String version;
        String installer;
        String location;

        PipPackageJson() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getInstaller() {
            return this.installer;
        }

        public void setInstaller(String installer) {
            this.installer = installer;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }
    }

    final class PipDownload
    implements Callable<PipInstalledPackage> {
        private PipInstalledPackage pack = null;

        PipDownload(PipInstalledPackage _pack) {
            this.pack = _pack;
        }

        @Override
        public PipInstalledPackage call() throws ProcessWrapperException, IOException {
            Path download_dir = FileUtil.createTmpDir((String)(this.pack.getName() + "-"));
            ProcessWrapper pw = new ProcessWrapper();
            pw.setCommand(PipWrapper.this.pathToPip, "download", "-d", download_dir.toString(), "--no-cache-dir", this.pack.getName() + "==" + this.pack.getVersion());
            pw.setPath(PipWrapper.this.logDir);
            pw.run();
            Path download_info = pw.getOutFile();
            PipWrapper.this.searchDownloadInfo(this.pack, FileUtil.readFile((Path)download_info));
            return this.pack;
        }
    }

    final class PipShow
    implements Callable<PipInstalledPackage> {
        private PipInstalledPackage pack = null;

        PipShow(PipInstalledPackage _pack) {
            this.pack = _pack;
        }

        @Override
        public PipInstalledPackage call() throws ProcessWrapperException, IOException {
            ProcessWrapper pw = new ProcessWrapper(this.pack.getName());
            pw.setCommand(PipWrapper.this.pathToPip, "show", this.pack.getName()).setPath(PipWrapper.this.logDir);
            pw.run();
            if (pw.terminatedWithSuccess()) {
                this.pack.addProperties(PipWrapper.this.parsePipShowOutput(pw.getOutFile()));
                log.info("Added properties to " + this.pack);
            } else {
                log.info("Properties for " + this.pack + " are missing");
            }
            return this.pack;
        }
    }
}

