/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python.pip;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.python.ProcessWrapperException;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.StringUtil;

public class PyWrapper {
    private static final Logger log = LogManager.getLogger();
    private Path pathToPython = null;
    private Path logDir = null;

    public PyWrapper() throws ProcessWrapperException {
        this(Paths.get("python", new String[0]), null);
    }

    public PyWrapper(Path _path_to_python, Path _log_dir) throws ProcessWrapperException {
        this.pathToPython = _path_to_python;
        if (_log_dir != null) {
            this.logDir = _log_dir;
        } else {
            try {
                FileUtil.createTmpDir((String)"vulas-pip-");
            }
            catch (IOException e) {
                throw new ProcessWrapperException("Cannot create tmp directory: " + e.getMessage());
            }
        }
    }

    public boolean isAvailable() {
        boolean exists = false;
        try {
            Process p = new ProcessBuilder(this.pathToPython.toString()).start();
            int exit_code = p.waitFor();
            exists = exit_code == 0;
        }
        catch (IOException ioe) {
            log.error("Error calling [python]: " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            log.error("Error calling [python]: " + ie.getMessage(), (Throwable)ie);
        }
        return exists;
    }

    public int runScript(Path _script, List<String> _args) {
        int exit_code = -1;
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.pathToPython.toString());
        list.add(_script.toString());
        list.addAll(_args);
        String script_name = _script.getFileName().toString();
        try {
            ProcessBuilder pb = new ProcessBuilder(list);
            Path out = Paths.get(this.logDir.toString(), "python-" + script_name + "-out.txt");
            Path err = Paths.get(this.logDir.toString(), "python-" + script_name + "-err.txt");
            pb.redirectOutput(out.toFile());
            pb.redirectError(err.toFile());
            Process process = pb.start();
            exit_code = process.waitFor();
            if (exit_code != 0) {
                String error_msg = FileUtil.readFile((Path)err);
                log.error("Error calling [python " + StringUtil.join(list, (String)" ") + "]: " + error_msg);
            }
        }
        catch (IOException ioe) {
            log.error("Error calling [python " + StringUtil.join(list, (String)" ") + "]: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            log.error("Error calling [python " + StringUtil.join(list, (String)" ") + "]: " + ie.getMessage());
        }
        return exit_code;
    }
}

