/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python.sign;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.eclipse.steady.python.sign.PythonConstructDigest;
import org.eclipse.steady.shared.enums.DigestAlgorithm;

public class PythonConstructDigestDeserializer
extends StdDeserializer<PythonConstructDigest> {
    public PythonConstructDigestDeserializer() {
        this(null);
    }

    public PythonConstructDigestDeserializer(Class<PythonConstructDigest> t) {
        super(t);
    }

    public PythonConstructDigest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode json_root = (JsonNode)p.getCodec().readTree(p);
        String computedFrom = json_root.findValue("computedFrom").asText();
        PythonConstructDigest.ComputedFromType computedFromType = PythonConstructDigest.ComputedFromType.valueOf(json_root.findValue("computedFromType").asText());
        String digest = json_root.findValue("digest").asText();
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.fromString((String)json_root.findValue("digestAlgorithm").asText());
        PythonConstructDigest pythonConstructDigest = new PythonConstructDigest(digest, digestAlgorithm);
        pythonConstructDigest.setComputedFrom(computedFrom);
        pythonConstructDigest.setComputedFromType(computedFromType);
        return pythonConstructDigest;
    }
}

