/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python.sign;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.Construct;
import org.eclipse.steady.FileAnalysisException;
import org.eclipse.steady.FileAnalyzerFactory;
import org.eclipse.steady.python.Python3FileAnalyzer;
import org.eclipse.steady.python.sign.PythonConstructDigest;
import org.eclipse.steady.shared.enums.ConstructType;
import org.eclipse.steady.shared.enums.DigestAlgorithm;
import org.eclipse.steady.shared.enums.ProgrammingLanguage;
import org.eclipse.steady.shared.json.model.ConstructId;
import org.eclipse.steady.sign.Signature;
import org.eclipse.steady.sign.SignatureChange;
import org.eclipse.steady.sign.SignatureFactory;

public class PythonSignatureFactory
implements SignatureFactory {
    private static final Logger log = LogManager.getLogger();

    public boolean isSupportedConstructId(ConstructId _id) {
        return _id != null && ProgrammingLanguage.PY.equals((Object)_id.getLang()) && (ConstructType.FUNC.equals((Object)_id.getType()) || ConstructType.MODU.equals((Object)_id.getType()) || ConstructType.METH.equals((Object)_id.getType()) || ConstructType.CONS.equals((Object)_id.getType()));
    }

    public Signature createSignature(Construct _construct) {
        if (_construct != null && _construct.getContent() != null) {
            return new PythonConstructDigest(_construct.getContent(), DigestAlgorithm.SHA1);
        }
        return null;
    }

    public Signature createSignature(ConstructId _cid, File _file) {
        if (!_cid.getLang().equals((Object)ProgrammingLanguage.PY)) {
            throw new IllegalArgumentException("Programming language [" + _cid.getLang() + "] not supported");
        }
        PythonConstructDigest signature = null;
        if (_cid.getType().equals((Object)ConstructType.MODU)) {
            signature = new PythonConstructDigest(_file.toPath(), DigestAlgorithm.SHA1);
        } else {
            try {
                Python3FileAnalyzer fa = (Python3FileAnalyzer)FileAnalyzerFactory.buildFileAnalyzer((File)_file, (String[])new String[]{"py"});
                Construct c = fa.getConstruct(_cid);
                if (c == null) {
                    throw new IllegalStateException("Construct [" + _cid + "] cannot be found in file [" + _file + "]");
                }
                signature = new PythonConstructDigest(c.getContent(), DigestAlgorithm.SHA1);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
            catch (FileAnalysisException e) {
                log.error((Object)e);
            }
        }
        return signature;
    }

    public SignatureChange computeChange(Construct _from, Construct _to) {
        return null;
    }
}

