/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.ConstructId;
import org.eclipse.steady.FileAnalysisException;
import org.eclipse.steady.FileAnalyzer;
import org.eclipse.steady.FileAnalyzerFactory;
import org.eclipse.steady.goals.GoalConfigurationException;
import org.eclipse.steady.goals.GoalExecutionException;
import org.eclipse.steady.python.ProcessWrapperException;
import org.eclipse.steady.python.PythonArchiveAnalyzer;
import org.eclipse.steady.python.pip.PipInstalledPackage;
import org.eclipse.steady.python.pip.PipWrapper;
import org.eclipse.steady.python.virtualenv.VirtualenvWrapper;
import org.eclipse.steady.shared.enums.ProgrammingLanguage;
import org.eclipse.steady.shared.enums.Scope;
import org.eclipse.steady.shared.json.model.Application;
import org.eclipse.steady.shared.json.model.Dependency;
import org.eclipse.steady.shared.json.model.Library;
import org.eclipse.steady.shared.util.DependencyUtil;
import org.eclipse.steady.shared.util.DirWithFileSearch;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.StringUtil;
import org.eclipse.steady.shared.util.VulasConfiguration;
import org.eclipse.steady.tasks.AbstractBomTask;

public class PythonBomTask
extends AbstractBomTask {
    private static final Logger log = LogManager.getLogger();
    private static final String[] EXT_FILTER = new String[]{"whl", "egg", "py"};

    public Set<ProgrammingLanguage> getLanguage() {
        return new HashSet<ProgrammingLanguage>(Arrays.asList(ProgrammingLanguage.PY));
    }

    public void configure(VulasConfiguration _cfg) throws GoalConfigurationException {
        super.configure(_cfg);
    }

    public void execute() throws GoalExecutionException {
        Application a = this.getApplication();
        HashSet<PipInstalledPackage> app_pip_packs = new HashSet<PipInstalledPackage>();
        if (this.vulasConfiguration.isEmpty("vulas.core.bom.python.pip")) {
            log.info("Determine app dependencies by finding setup.py files below the search path(s), and installing them in virtual environments");
            HashSet prj_paths = new HashSet();
            DirWithFileSearch search = new DirWithFileSearch("setup.py");
            for (Path p : this.getSearchPath()) {
                log.info("Searching for Python projects in search path [" + p + "]");
                search.clear();
                prj_paths.addAll(search.search(p));
            }
            log.info("Found [" + prj_paths.size() + "] Python projects in search path(s)");
            if (!prj_paths.isEmpty()) {
                for (Path p : prj_paths) {
                    log.info("Analyzing Python project in [" + p + "]");
                    try {
                        VirtualenvWrapper vew = new VirtualenvWrapper(p);
                        app_pip_packs.addAll(vew.getInstalledPackages());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            try {
                String pip_path = this.vulasConfiguration.getConfiguration().getString("vulas.core.bom.python.pip");
                log.info("Determine app dependencies using [" + pip_path + "]");
                PipWrapper pip = new PipWrapper(Paths.get(pip_path, new String[0]), null);
                app_pip_packs.addAll(pip.getFreezePackages());
            }
            catch (ProcessWrapperException e) {
                throw new GoalExecutionException("Error creating pip wrapper: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new GoalExecutionException("Error creating pip wrapper: " + e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new GoalExecutionException("Error creating pip wrapper: " + e.getMessage(), (Throwable)e);
            }
        }
        if (app_pip_packs.size() == 0) {
            log.warn("No dependencies found");
        }
        a.addDependencies(this.toDependencies(app_pip_packs));
        HashSet app_constructs = new HashSet();
        for (Path p : this.getSearchPath()) {
            try {
                if (!FileUtil.isAccessibleDirectory((Path)p) && !FileUtil.hasFileExtension((Path)p, (String[])EXT_FILTER)) continue;
                log.info("Searching for Python constructs in search path [" + p + "] with filter [" + StringUtil.join((String[])EXT_FILTER, (String)", ") + "]");
                FileAnalyzer da = FileAnalyzerFactory.buildFileAnalyzer((File)p.toFile(), (String[])EXT_FILTER);
                app_constructs.addAll(da.getConstructs().keySet());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        a.addConstructs(ConstructId.getSharedType(app_constructs));
        this.setCompletedApplication(a);
    }

    private Set<Dependency> toDependencies(Set<PipInstalledPackage> _packs) {
        PipInstalledPackage prj_package = null;
        for (PipInstalledPackage pack : _packs) {
            if (!pack.getStandardDistributionName().equals(PipInstalledPackage.getStandardDistributionName(this.getApplication().getMvnGroup()))) continue;
            prj_package = pack;
            break;
        }
        HashSet<Dependency> deps = new HashSet<Dependency>();
        for (PipInstalledPackage pack : _packs) {
            try {
                if (prj_package != null && prj_package.equals(pack) || !pack.getLibrary().hasValidDigest()) continue;
                Dependency dep = new Dependency();
                dep.setLib(pack.getLibrary());
                dep.setApp(this.getApplication());
                Path download_path = pack.getDownloadPath();
                if (download_path != null) {
                    dep.setFilename(download_path.getFileName().toString());
                    dep.setPath(download_path.toString());
                }
                dep.setDeclared(Boolean.valueOf(true));
                dep.setScope(Scope.RUNTIME);
                dep.setTransitive(Boolean.valueOf(prj_package == null || !prj_package.requires(pack)));
                deps.add(dep);
            }
            catch (FileAnalysisException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        for (PipInstalledPackage pack : _packs) {
            Set<FileAnalyzer> nested_fas = pack.getNestedArchives();
            if (nested_fas == null) continue;
            for (FileAnalyzer nested_fa : nested_fas) {
                if (nested_fa instanceof PythonArchiveAnalyzer) {
                    try {
                        PythonArchiveAnalyzer paa = (PythonArchiveAnalyzer)nested_fa;
                        Library nested_lib = paa.getLibrary();
                        if (DependencyUtil.containsLibraryDependency(deps, (Library)nested_lib)) {
                            log.warn("Dependency for library " + nested_lib + " already exists, will not be duplicated for the nested library with path [" + paa.getArchivePath() + "]");
                            continue;
                        }
                        Dependency dep = new Dependency();
                        dep.setLib(nested_lib);
                        dep.setApp(this.getApplication());
                        Path archive_path = paa.getArchivePath();
                        if (archive_path != null) {
                            dep.setFilename(archive_path.getFileName().toString());
                            dep.setPath(archive_path.toString());
                        }
                        dep.setDeclared(Boolean.valueOf(false));
                        dep.setScope(Scope.RUNTIME);
                        dep.setTransitive(Boolean.valueOf(true));
                        deps.add(dep);
                    }
                    catch (FileAnalysisException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                log.warn("Nested analyzer of unexpected type [" + nested_fa.getClass().getSimpleName() + "]");
            }
        }
        return deps;
    }
}

