/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.Construct;
import org.eclipse.steady.ConstructId;
import org.eclipse.steady.FileAnalysisException;
import org.eclipse.steady.FileAnalyzer;
import org.eclipse.steady.python.PythonFileAnalyzer;
import org.eclipse.steady.python.PythonId;
import org.eclipse.steady.python.antlr.python335.Python335BaseListener;
import org.eclipse.steady.python.antlr.python335.Python335Lexer;
import org.eclipse.steady.python.antlr.python335.Python335Parser;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.StringUtil;

public class Python335FileAnalyzer
extends Python335BaseListener
implements FileAnalyzer {
    private static final Logger log = LogManager.getLogger();
    protected Map<ConstructId, Construct> constructs = null;
    protected final Stack<PythonId> context = new Stack();
    protected final List<String> stmts = new ArrayList<String>();
    protected final Map<PythonId, Map<String, Integer>> countPerContext = new HashMap<PythonId, Map<String, Integer>>();
    private PythonId module = null;
    private File file = null;

    public String[] getSupportedFileExtensions() {
        return new String[0];
    }

    public void setContext(PythonId _module, PythonId _pack) {
        this.constructs = new TreeMap<ConstructId, Construct>();
        if (_pack != null) {
            this.context.push(_pack);
            this.constructs.put(_pack, new Construct((ConstructId)_pack, ""));
        }
        this.context.push(_module);
        this.module = _module;
        this.constructs.put(this.module, new Construct((ConstructId)this.module, ""));
    }

    public boolean canAnalyze(File _file) {
        String ext = FileUtil.getFileExtension((File)_file);
        if (ext == null || ext.equals("")) {
            return false;
        }
        for (String supported_ext : this.getSupportedFileExtensions()) {
            if (!supported_ext.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    public void analyze(File _file) throws FileAnalysisException {
        if (!FileUtil.isAccessibleFile((Path)_file.toPath())) {
            throw new IllegalArgumentException("[" + _file + "] does not exist or is not readable");
        }
        this.file = _file;
    }

    @Override
    public void enterStmt(Python335Parser.StmtContext ctx) {
        String stmt = ctx.getText();
        if (!PythonFileAnalyzer.isTopOfType(this.context, PythonId.Type.MODULE) || stmt.startsWith("def") || stmt.startsWith("class")) {
            return;
        }
        this.stmts.add(stmt);
    }

    @Override
    public void enterClassdef(Python335Parser.ClassdefContext ctx) {
        if (ctx.NAME() == null) {
            throw new IllegalStateException("Parser error: Class without name in context " + this.context + ", line [" + ctx.getStart().getLine() + "]");
        }
        String name = ctx.NAME().toString();
        String parent_classes = "";
        if (ctx.arglist() != null) {
            parent_classes = ctx.arglist().getText().toString();
        }
        PythonId id = new PythonId(this.context.peek(), PythonId.Type.CLASS, name + "(" + parent_classes + ")");
        Construct c = new Construct((ConstructId)id, ctx.getText());
        this.constructs.put(id, c);
        this.context.push(id);
    }

    @Override
    public void exitClassdef(Python335Parser.ClassdefContext ctx) {
        if (!PythonFileAnalyzer.isTopOfType(this.context, PythonId.Type.CLASS)) {
            log.error("Top most element in stack is not of type [" + (Object)((Object)PythonId.Type.CLASS) + "], line [" + ctx.getStart().getLine() + "]");
        } else {
            this.context.pop();
        }
    }

    @Override
    public void enterFuncdef(Python335Parser.FuncdefContext ctx) {
        PythonId id;
        if (ctx.NAME() == null) {
            throw new IllegalStateException("Parser error: Construct without name in context " + this.context + ", line [" + ctx.getStart().getLine() + "]");
        }
        String name = ctx.NAME().toString();
        String args = ctx.parameters().getText();
        name = this.getNameForCurrentContext(name);
        PythonId.Type ctx_type = this.context.peek().getType();
        if (ctx_type == PythonId.Type.CLASS && name.equals("__init__")) {
            id = new PythonId(this.context.peek(), PythonId.Type.CONSTRUCTOR, name + args);
        } else if (ctx_type == PythonId.Type.CLASS) {
            id = new PythonId(this.context.peek(), PythonId.Type.METHOD, name + args);
        } else if (ctx_type == PythonId.Type.MODULE || ctx_type == PythonId.Type.FUNCTION || ctx_type == PythonId.Type.METHOD || ctx_type == PythonId.Type.CONSTRUCTOR) {
            id = new PythonId(this.context.peek(), PythonId.Type.FUNCTION, name + args);
        } else {
            log.error("Cannot create method, constructor or class due to wrong context: " + this.context + ", line [" + ctx.getStart().getLine() + "]");
            throw new IllegalStateException("Error when parsing [" + this.file + "]: Cannot create method or class due to wrong context: " + this.context);
        }
        Construct c = new Construct((ConstructId)id, ctx.getText());
        this.constructs.put(id, c);
        this.context.push(id);
    }

    @Override
    public void exitFuncdef(Python335Parser.FuncdefContext _ctx) {
        PythonId.Type[] types = new PythonId.Type[]{PythonId.Type.FUNCTION, PythonId.Type.CONSTRUCTOR, PythonId.Type.METHOD};
        if (!PythonFileAnalyzer.isTopOfType(this.context, types)) {
            log.error("Top most element in stack is not of the following types [" + StringUtil.join((Object[])((Object[])types), (String)", ") + "], line [" + _ctx.getStart().getLine() + "]");
        } else {
            this.context.pop();
        }
    }

    private String getNameForCurrentContext(String _name) {
        PythonId ctx = this.context.peek();
        if (this.countPerContext.get((Object)ctx) == null) {
            this.countPerContext.put(ctx, new HashMap());
        }
        if (this.countPerContext.get((Object)ctx).get(_name) == null) {
            this.countPerContext.get((Object)ctx).put(_name, 0);
        }
        int count = this.countPerContext.get((Object)ctx).get(_name);
        this.countPerContext.get((Object)ctx).put(_name, ++count);
        if (count == 1) {
            return _name;
        }
        return _name + "$" + count;
    }

    public boolean containsConstruct(ConstructId _id) throws FileAnalysisException {
        return this.constructs.containsKey(_id);
    }

    public Construct getConstruct(org.eclipse.steady.shared.json.model.ConstructId _id) throws FileAnalysisException {
        for (Map.Entry<ConstructId, Construct> e : this.constructs.entrySet()) {
            if (!ConstructId.toSharedType((ConstructId)e.getKey()).equals((Object)_id)) continue;
            return e.getValue();
        }
        return null;
    }

    public Construct getConstruct(ConstructId _id) throws FileAnalysisException {
        return this.constructs.get(_id);
    }

    public Map<ConstructId, Construct> getConstructs(InputStream m) throws FileAnalysisException, IOException, RecognitionException {
        CharStream input = CharStreams.fromStream((InputStream)m);
        Python335Lexer lexer = new Python335Lexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python335Parser parser = new Python335Parser((TokenStream)tokens);
        Python335Parser.File_inputContext root = parser.file_input();
        ParseTreeWalker walker = new ParseTreeWalker();
        try {
            walker.walk((ParseTreeListener)this, (ParseTree)root);
        }
        catch (IllegalStateException ise) {
            throw new FileAnalysisException("Parser error", (Throwable)ise);
        }
        if (this.stmts != null && this.stmts.size() > 0) {
            StringBuffer b = new StringBuffer();
            for (String stmt : this.stmts) {
                if (stmt.trim().equals("")) continue;
                b.append(stmt);
            }
            this.constructs.get((Object)this.module).setContent(b.toString());
        }
        return this.constructs;
    }

    public Map<ConstructId, Construct> getConstructs() throws FileAnalysisException {
        if (this.constructs == null) {
            try {
                this.constructs = new TreeMap<ConstructId, Construct>();
                this.module = PythonFileAnalyzer.getModule(this.file);
                this.constructs.put(this.module, new Construct((ConstructId)this.module, ""));
                PythonId pack = this.module.getPackage();
                if (pack != null) {
                    this.constructs.put(pack, new Construct((ConstructId)pack, ""));
                }
                if (pack != null) {
                    this.context.push(pack);
                }
                this.context.push(this.module);
                log.debug("Parsing [" + this.file + "]");
                try (FileInputStream fis = new FileInputStream(this.file);){
                    this.getConstructs(fis);
                }
            }
            catch (FileNotFoundException e) {
                throw new FileAnalysisException(e.getMessage(), (Throwable)e);
            }
            catch (RecognitionException e) {
                throw new FileAnalysisException("ANTLR exception while analysing class file [" + this.file.getName() + "]: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new FileAnalysisException("IO exception while analysing class file [" + this.file.getName() + "]: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.constructs;
    }

    public boolean hasChilds() {
        return false;
    }

    public Set<FileAnalyzer> getChilds(boolean _recursive) {
        return null;
    }

    public String toString() {
        return "Python335 parser for [" + this.file + "]";
    }
}

