/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python;

import com.google.gson.JsonObject;
import org.eclipse.steady.ConstructId;
import org.eclipse.steady.shared.enums.ConstructType;
import org.eclipse.steady.shared.enums.ProgrammingLanguage;
import org.eclipse.steady.shared.json.JsonBuilder;

public class PythonId
extends ConstructId {
    public static final String SCRIPT_NAME = "<script>";
    protected Type type = null;
    protected PythonId definitionContext = null;
    protected String simpleName = "";

    public static ConstructType toSharedType(Type _type) {
        switch (_type) {
            case CLASS: {
                return ConstructType.CLAS;
            }
            case METHOD: {
                return ConstructType.METH;
            }
            case MODULE: {
                return ConstructType.MODU;
            }
            case PACKAGE: {
                return ConstructType.PACK;
            }
            case FUNCTION: {
                return ConstructType.FUNC;
            }
            case CONSTRUCTOR: {
                return ConstructType.CONS;
            }
        }
        throw new IllegalArgumentException("Unknown type [" + (Object)((Object)_type) + "]");
    }

    public static Type typeFromString(String _t) {
        if ("PACK".equalsIgnoreCase(_t)) {
            return Type.PACKAGE;
        }
        if ("CLAS".equalsIgnoreCase(_t)) {
            return Type.CLASS;
        }
        if ("MODU".toString().equalsIgnoreCase(_t)) {
            return Type.MODULE;
        }
        if ("FUNC".toString().equalsIgnoreCase(_t)) {
            return Type.FUNCTION;
        }
        if ("CONS".toString().equalsIgnoreCase(_t)) {
            return Type.CONSTRUCTOR;
        }
        if ("METH".toString().equalsIgnoreCase(_t)) {
            return Type.METHOD;
        }
        throw new IllegalArgumentException("Unknown type [" + _t + "]");
    }

    PythonId(PythonId _ctx, Type _t, String _simple_name) {
        super(ProgrammingLanguage.PY);
        if (_t == Type.PACKAGE && _ctx != null) {
            throw new IllegalArgumentException("Packages cannot have a definition context");
        }
        this.definitionContext = _ctx;
        this.type = _t;
        this.simpleName = _simple_name;
    }

    public Type getType() {
        return this.type;
    }

    public ConstructType getSharedType() {
        return PythonId.toSharedType(this.type);
    }

    public PythonId getPackage() {
        PythonId pack = null;
        if (this.type != Type.PACKAGE && this.definitionContext != null) {
            pack = this.definitionContext.getType() == Type.PACKAGE ? this.definitionContext : this.getDefinitionContext().getPackage();
        }
        return pack;
    }

    public PythonId getDefinitionContext() {
        return this.definitionContext;
    }

    public String getName() {
        return this.simpleName;
    }

    public String getQualifiedName() {
        StringBuffer b = new StringBuffer();
        if (this.definitionContext != null) {
            b.append(this.definitionContext.getQualifiedName()).append(".");
        }
        b.append(this.simpleName);
        return b.toString();
    }

    public String toString() {
        return this.getLanguage() + " " + this.getSharedType().toString() + " [" + this.getQualifiedName() + "]";
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public JsonObject toGSON() {
        JsonObject jb = new JsonObject();
        jb.addProperty("lang", this.getLanguage().toString());
        jb.addProperty("type", this.getSharedType().toString());
        jb.addProperty("qname", this.getQualifiedName());
        return jb;
    }

    public String toJSON() {
        JsonBuilder jb = new JsonBuilder();
        jb.startObject();
        jb.appendObjectProperty("lang", this.getLanguage().toString());
        jb.appendObjectProperty("type", this.getSharedType().toString());
        jb.appendObjectProperty("qname", this.getQualifiedName());
        jb.endObject();
        return jb.getJson();
    }

    public static enum Type {
        PACKAGE,
        MODULE,
        CLASS,
        CONSTRUCTOR,
        METHOD,
        FUNCTION;

    }
}

