/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python.sign;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.eclipse.steady.shared.enums.DigestAlgorithm;
import org.eclipse.steady.shared.json.JsonBuilder;
import org.eclipse.steady.shared.util.DigestUtil;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.sign.Signature;

public class PythonConstructDigest
implements Signature {
    private static final int MAX_STRING_LENGTH = 100;
    private String computedFrom = null;
    private ComputedFromType computedFromType = null;
    private String digest = null;
    private DigestAlgorithm digestAlgorithm = null;

    public PythonConstructDigest(Path _path, DigestAlgorithm _alg) throws IllegalArgumentException {
        if (!FileUtil.isAccessibleFile((Path)_path)) {
            throw new IllegalArgumentException("Path argument [" + _path + "] is not a valid file");
        }
        this.digest = FileUtil.getDigest((File)_path.toFile(), (DigestAlgorithm)_alg);
        this.digestAlgorithm = _alg;
        this.computedFrom = _path.getFileName().toString();
        this.computedFromType = ComputedFromType.FILE;
    }

    public PythonConstructDigest(String _string, DigestAlgorithm _alg) {
        if (_string == null) {
            throw new IllegalArgumentException("String argument cannot be null");
        }
        this.digest = DigestUtil.getDigestAsString((String)_string, (Charset)StandardCharsets.UTF_8, (DigestAlgorithm)_alg);
        this.digestAlgorithm = _alg;
        this.computedFrom = _string.length() > 100 ? _string.substring(0, 97) + "..." : _string;
        this.computedFromType = ComputedFromType.BODY;
    }

    public String getComputedFrom() {
        return this.computedFrom;
    }

    public void setComputedFrom(String computedFrom) {
        this.computedFrom = computedFrom;
    }

    public ComputedFromType getComputedFromType() {
        return this.computedFromType;
    }

    public void setComputedFromType(ComputedFromType computedFromType) {
        this.computedFromType = computedFromType;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public String toString() {
        return this.digest + " (" + this.digestAlgorithm + ")";
    }

    public String toJson() {
        JsonBuilder b = new JsonBuilder();
        b.startObject();
        b.appendObjectProperty("digest", this.digest);
        b.appendObjectProperty("digestAlgorithm", this.digestAlgorithm.toString());
        b.appendObjectProperty("computedFrom", this.computedFrom);
        b.appendObjectProperty("computedFromType", this.computedFromType.toString());
        b.endObject();
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.digest == null ? 0 : this.digest.hashCode());
        result = 31 * result + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PythonConstructDigest other = (PythonConstructDigest)obj;
        if (this.digest == null ? other.digest != null : !this.digest.equals(other.digest)) {
            return false;
        }
        return this.digestAlgorithm == other.digestAlgorithm;
    }

    public static enum ComputedFromType {
        FILE,
        BODY;

    }
}

