/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python.virtualenv;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.python.ProcessWrapperException;
import org.eclipse.steady.python.pip.PipInstalledPackage;
import org.eclipse.steady.python.pip.PipWrapper;
import org.eclipse.steady.python.pip.PyWrapper;
import org.eclipse.steady.shared.util.DirUtil;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.VulasConfiguration;

public class VirtualenvWrapper {
    private static final String SETUP_PY = "setup.py";
    private static final boolean IS_WIN = System.getProperty("os.name").contains("Windows");
    private static final Logger log = LogManager.getLogger();
    private Path pathToVirtualenvExecutable = null;
    private Path pathToPythonProject = null;
    private String projectName = null;
    private Path pathToVirtualenv = null;
    private Set<PipInstalledPackage> installedPackages = null;

    public VirtualenvWrapper(Path _path_to_python_project) throws IllegalArgumentException, ProcessWrapperException {
        this(Paths.get("virtualenv", new String[0]), _path_to_python_project);
    }

    public VirtualenvWrapper(Path _path_to_virtualenv, Path _path_to_python_project) throws IllegalArgumentException, ProcessWrapperException {
        if (!FileUtil.isAccessibleDirectory((Path)_path_to_python_project)) {
            throw new IllegalArgumentException("Project path [" + _path_to_python_project + "] does not point to an accessible directory");
        }
        if (!DirUtil.containsFile((File)_path_to_python_project.toFile(), (String)SETUP_PY)) {
            throw new IllegalArgumentException("Project path [" + _path_to_python_project + "] does not contain the file [" + SETUP_PY + "]");
        }
        this.pathToVirtualenvExecutable = _path_to_virtualenv;
        this.pathToPythonProject = _path_to_python_project.toAbsolutePath();
        this.projectName = this.pathToPythonProject.getName(this.pathToPythonProject.getNameCount() - 1).toString();
        try {
            this.pathToVirtualenv = FileUtil.createTmpDir((String)("vulas-virtualenv-" + this.projectName + "-")).toAbsolutePath();
        }
        catch (IOException e) {
            throw new ProcessWrapperException("Cannot create tmp directory: " + e.getMessage());
        }
        this.createVirtualenvForProject(this.pathToVirtualenv);
        this.copyProjectDirectory();
        Path prj_path = Paths.get(this.pathToVirtualenv.toString(), this.projectName);
        this.installedPackages = this.getPipWrapper().installPackages(prj_path);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Path getPathToVirtualenv() {
        return this.pathToVirtualenv;
    }

    public Set<PipInstalledPackage> getInstalledPackages() {
        return this.installedPackages;
    }

    public PipWrapper getPipWrapper() throws ProcessWrapperException {
        if (IS_WIN) {
            return new PipWrapper(Paths.get(this.pathToVirtualenv.toString(), "Scripts", "pip"), this.pathToVirtualenv);
        }
        return new PipWrapper(Paths.get(this.pathToVirtualenv.toString(), "bin", "pip"), this.pathToVirtualenv);
    }

    public PyWrapper getPyWrapper() throws ProcessWrapperException {
        if (IS_WIN) {
            return new PyWrapper(Paths.get(this.pathToVirtualenv.toString(), "Scripts", "python"), this.pathToVirtualenv);
        }
        return new PyWrapper(Paths.get(this.pathToVirtualenv.toString(), "bin", "python"), this.pathToVirtualenv);
    }

    private void createVirtualenvForProject(Path _path_to_virtual_env) throws ProcessWrapperException {
        Object ve = null;
        try {
            log.info("Create virtualenv in [" + _path_to_virtual_env + "]");
            ProcessBuilder pb = null;
            pb = VulasConfiguration.getGlobal().isEmpty("vulas.core.bom.python.python") ? new ProcessBuilder(this.pathToVirtualenvExecutable.toString(), _path_to_virtual_env.toString()) : new ProcessBuilder(this.pathToVirtualenvExecutable.toString(), "--python", VulasConfiguration.getGlobal().getConfiguration().getString("vulas.core.bom.python.python"), _path_to_virtual_env.toString());
            Path out = Paths.get(_path_to_virtual_env.toString(), "virtualenv-out.txt");
            Path err = Paths.get(_path_to_virtual_env.toString(), "virtualenv-err.txt");
            pb.redirectOutput(out.toFile());
            pb.redirectError(err.toFile());
            Process process = pb.start();
            int exit_code = process.waitFor();
            if (exit_code != 0) {
                String error_msg = FileUtil.readFile((Path)err);
                throw new ProcessWrapperException(error_msg);
            }
        }
        catch (IOException e) {
            throw new ProcessWrapperException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new ProcessWrapperException(e.getMessage(), e);
        }
    }

    private Path copyProjectDirectory() throws ProcessWrapperException {
        Path new_dir = null;
        try {
            Files.walkFileTree(this.pathToPythonProject, new HashSet<FileVisitOption>(), Integer.MAX_VALUE, new CopyFileVisitor(this.pathToPythonProject, this.pathToVirtualenv));
        }
        catch (Exception e) {
            new_dir = null;
            log.error("Cannot copy project dir [" + this.pathToPythonProject + "] to virtual env [" + this.pathToVirtualenvExecutable + "]:" + e.getMessage());
            throw new ProcessWrapperException("Cannot copy project dir [" + this.pathToPythonProject + "] to virtual env [" + this.pathToVirtualenvExecutable + "]:" + e.getMessage());
        }
        return new_dir;
    }

    private static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private static final Logger log = LogManager.getLogger();
        private Path src = null;
        private Path tgt = null;

        public CopyFileVisitor(Path _src, Path _tgt) {
            this.src = _src;
            this.tgt = _tgt;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path relp = this.src.getParent().relativize(dir.toAbsolutePath());
            Path newp = Paths.get(this.tgt.toString(), relp.toString());
            try {
                Files.createDirectories(newp, new FileAttribute[0]);
            }
            catch (Exception e) {
                log.error("Cannot copy [" + dir + "] to [" + newp + "]: " + e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path relp = this.src.getParent().relativize(file);
            Path newf = Paths.get(this.tgt.toString(), relp.toString());
            try {
                Files.copy(file, newf, new CopyOption[0]);
            }
            catch (Exception e) {
                log.error("Cannot copy [" + file + "] to [" + newf + "]: " + e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

