/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.steady.python;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.steady.python.ProcessWrapperException;
import org.eclipse.steady.shared.util.FileUtil;
import org.eclipse.steady.shared.util.StringUtil;

public class ProcessWrapper
implements Runnable {
    private static Logger log = LogManager.getLogger();
    private static final Pattern ALLOWED = Pattern.compile("[\\.\\-\\w=]+");
    private String id = null;
    private Path exe = null;
    private String[] args = null;
    private Path outPath = null;
    private Path outFile = null;
    private Path errFile;
    private int exitCode = -1;

    public ProcessWrapper() {
        this.id = StringUtil.getRandonString((int)10);
    }

    public ProcessWrapper(String _id) {
        this.id = _id;
    }

    public String getId() {
        return this.id;
    }

    public ProcessWrapper setCommand(Path _executable, String ... _args) throws ProcessWrapperException {
        for (int i = 0; i < _args.length; ++i) {
            Matcher m = ALLOWED.matcher(_args[i]);
            if (m.matches() || FileUtil.isAccessibleFile((String)_args[i]) || FileUtil.isAccessibleDirectory((String)_args[i])) continue;
            throw new ProcessWrapperException("Illegal characters in argument [" + i + "], allowed are: a-zA-Z_0-9-.=");
        }
        this.exe = _executable;
        this.args = _args;
        return this;
    }

    public ProcessWrapper setPath(Path _p) {
        this.outPath = _p;
        return this;
    }

    @Override
    public void run() {
        String name = null;
        name = FileUtil.isAccessibleFile((Path)this.exe) ? this.exe.getFileName().toString() : (this.exe.toString().indexOf(System.getProperty("file.separator")) != -1 ? this.exe.toString().substring(this.exe.toString().lastIndexOf(System.getProperty("file.separator")) + 1) : this.exe.toString());
        String rnd = StringUtil.getRandonString((int)6);
        String out_name = name + "-" + this.getId() + "-" + rnd + "-out.txt";
        String err_name = name + "-" + this.getId() + "-" + rnd + "-err.txt";
        this.outFile = Paths.get(this.outPath.toString(), out_name);
        this.errFile = Paths.get(this.outPath.toString(), err_name);
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.exe.toString());
            cmd.addAll(Arrays.asList(this.args));
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectOutput(this.outFile.toFile());
            pb.redirectError(this.errFile.toFile());
            Process process = pb.start();
            this.exitCode = process.waitFor();
            if (this.exitCode != 0) {
                String error_msg = FileUtil.readFile((Path)this.errFile);
                log.error("Error running [" + this.getCommand() + "]: " + error_msg);
            }
        }
        catch (IOException ioe) {
            log.error("Error running [" + this.getCommand() + "]: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            log.error("Error running [" + this.getCommand() + "]: " + ie.getMessage());
        }
    }

    public Path getOutFile() {
        return this.outFile;
    }

    public Path getErrFile() {
        return this.errFile;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean terminatedWithSuccess() {
        return this.exitCode == 0;
    }

    public String getCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.exe.toString());
        cmd.addAll(Arrays.asList(this.args));
        return StringUtil.join(cmd, (String)" ");
    }
}

