/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.script;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Filter;
import org.eobjects.analyzer.beans.api.FilterBean;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.StringProperty;
import org.eobjects.analyzer.beans.categories.ScriptingCategory;
import org.eobjects.analyzer.beans.filter.ValidationCategory;
import org.eobjects.analyzer.beans.script.JavaScriptUtils;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterBean(value="JavaScript filter")
@Description(value="Supply your own piece of JavaScript that evaluates whether rows should be included or excluded from processing.")
@Categorized(value={ScriptingCategory.class})
public class JavaScriptFilter
implements Filter<ValidationCategory> {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptFilter.class);
    @Configured
    InputColumn<?>[] columns;
    @Configured
    @Description(value="Available variables:\nvalues[0..]: Array of values\nvalues[\"my_col\"]: Map of values\nmy_col: Each column value has it's own variable\nout: Print to console using out.println('hello')\nlogger: Print to log using log.info(...), log.warn(...), log.error(...)")
    @StringProperty(multiline=true, mimeType={"text/javascript", "application/x-javascript"})
    String sourceCode = "function eval() {\n  return values[0] != null;\n}\n\neval();";
    private ContextFactory _contextFactory;
    private Script _script;
    private ScriptableObject _sharedScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initialize
    public void init() {
        this._contextFactory = new ContextFactory();
        Context context = this._contextFactory.enterContext();
        try {
            this._script = context.compileString(this.sourceCode, this.getClass().getSimpleName(), 1, null);
            this._sharedScope = context.initStandardObjects();
            JavaScriptUtils.addToScope((Scriptable)this._sharedScope, logger, "logger", "log");
            JavaScriptUtils.addToScope((Scriptable)this._sharedScope, System.out, "out");
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationCategory categorize(InputRow inputRow) {
        Context context = this._contextFactory.enterContext();
        try {
            Scriptable scope = context.newObject((Scriptable)this._sharedScope);
            scope.setPrototype((Scriptable)this._sharedScope);
            scope.setParentScope(null);
            JavaScriptUtils.addToScope(scope, inputRow, this.columns, "values");
            Object result = this._script.exec(context, scope);
            boolean booleanResult = Context.toBoolean((Object)result);
            ValidationCategory validationCategory = ValidationCategory.valueOf((boolean)booleanResult);
            return validationCategory;
        }
        finally {
            Context.exit();
        }
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public void setColumns(InputColumn<?>[] columns) {
        this.columns = columns;
    }
}

