/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.PackageInfo;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.Universe;
import org.expath.pkg.repo.deps.DependencyVersion;
import org.expath.pkg.repo.deps.PkgDependency;
import org.expath.pkg.repo.deps.ProcessorDependency;
import org.expath.pkg.repo.tools.Logger;

public class Package
implements Universe {
    private Repository myRepo;
    private Storage.PackageResolver myResolver;
    private String myName;
    private String myAbbrev;
    private String myVersion;
    private String myTitle;
    private String myHome;
    private List<PkgDependency> myPkgDeps = new ArrayList<PkgDependency>();
    private List<ProcessorDependency> myProcDeps = new ArrayList<ProcessorDependency>();
    private Map<String, PackageInfo> myInfos;
    private Map<URISpace, Map<String, String>> myPublicUris;
    private static final Logger LOG = Logger.getLogger(Package.class);

    public Package(Repository repo, Storage.PackageResolver resolver, String name, String abbrev, String version, String title, String home) {
        this.myRepo = repo;
        this.myResolver = resolver;
        this.myName = name;
        this.myAbbrev = abbrev;
        this.myVersion = version;
        this.myTitle = title;
        this.myHome = home;
        this.myInfos = new HashMap<String, PackageInfo>();
        this.myPublicUris = new EnumMap<URISpace, Map<String, String>>(URISpace.class);
    }

    public void addPublicUri(URISpace space, String href, String relative) throws PackageException {
        LOG.debug("Package ''{0}'', add URI in {1}: ''{2}'', to map to ''({3})''", new Object[]{this.myName, space, href, relative});
        Map<String, String> map = this.myPublicUris.get((Object)space);
        if (map == null) {
            map = new HashMap<String, String>();
            this.myPublicUris.put(space, map);
        }
        if (map.get(href) != null) {
            String msg = "Public URI already exists in this package: " + href + " (" + relative + ")";
            throw new PackageException(msg);
        }
        map.put(href, relative);
    }

    private Source resolveInThisPackage(String href, URISpace space) throws PackageException {
        for (PackageInfo info : this.myInfos.values()) {
            Source res = info.resolve(href, space);
            if (res == null) continue;
            return res;
        }
        Map<String, String> map = this.myPublicUris.get((Object)space);
        if (map == null) {
            LOG.debug("Package ''{0}'', no URI in {1}", new Object[]{this.myName, space});
            return null;
        }
        String rel = map.get(href);
        if (rel == null) {
            LOG.debug("Package ''{0}'', not in {1}: ''{2}''", new Object[]{this.myName, space, href});
            return null;
        }
        LOG.debug("Package ''{0}'', resolved ''{1}'' in {2} to ''{3}''", new Object[]{this.myName, href, space, rel});
        try {
            return this.myResolver.resolveComponent(rel);
        }
        catch (Storage.NotExistException ex) {
            throw new PackageException("Resource does NOT exist in the package", ex);
        }
    }

    @Override
    public Source resolve(String href, URISpace space) throws PackageException {
        return this.resolve(href, space, true);
    }

    @Override
    public Source resolve(String href, URISpace space, boolean transitive) throws PackageException {
        LOG.debug("Package ''{0}'', resolve in {1}: ''{2}'' ({3})", new Object[]{this.myName, space, href, transitive});
        Source src = this.resolveInThisPackage(href, space);
        if (src != null) {
            return src;
        }
        if (transitive) {
            for (PkgDependency dep : this.myPkgDeps) {
                Package depended = this.resolveDependency(dep);
                if (depended != null) {
                    src = depended.resolve(href, space, transitive);
                }
                if (src == null) continue;
                return src;
            }
        }
        return null;
    }

    private Package resolveDependency(PkgDependency dep) throws PackageException {
        String name = dep.getPkgName();
        DependencyVersion version = dep.getVersion();
        Packages pp = this.myRepo.getPackages(name);
        if (pp == null) {
            return null;
        }
        for (Package pkg : pp.packages()) {
            if (!version.isCompatible(pkg.getVersion())) continue;
            return pkg;
        }
        return null;
    }

    public Storage.PackageResolver getResolver() {
        return this.myResolver;
    }

    public String getName() {
        return this.myName;
    }

    public String getAbbrev() {
        return this.myAbbrev;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public PackageInfo getInfo(String name) {
        return this.myInfos.get(name);
    }

    public void addInfo(String name, PackageInfo info) throws PackageException {
        if (this.getInfo(name) != null) {
            throw new PackageException("Info for '" + name + "' already set");
        }
        this.myInfos.put(name, info);
    }

    public void setInfo(String name, PackageInfo info) {
        this.myInfos.put(name, info);
    }

    public Collection<PkgDependency> getPackageDeps() {
        return this.myPkgDeps;
    }

    public void addPackageDep(String pkg, String versions, String semver, String min, String max) throws PackageException {
        DependencyVersion ver = DependencyVersion.makeVersion(versions, semver, min, max);
        PkgDependency dep = new PkgDependency(pkg, ver);
        this.myPkgDeps.add(dep);
    }

    public Collection<ProcessorDependency> getProcessorDeps() {
        return this.myProcDeps;
    }

    public void addProcessorDep(String proc, String versions, String semver, String min, String max) {
        ProcessorDependency dep = new ProcessorDependency(proc);
        dep.setVersions(versions);
        dep.setSemver(semver);
        dep.setSemverMin(min);
        dep.setSemverMax(max);
        this.myProcDeps.add(dep);
    }
}

