/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.deps;

import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.deps.DepNoVersion;
import org.expath.pkg.repo.deps.DepSemver;
import org.expath.pkg.repo.deps.DepSemverMax;
import org.expath.pkg.repo.deps.DepSemverMin;
import org.expath.pkg.repo.deps.DepSemverMinMax;
import org.expath.pkg.repo.deps.DepVersions;

public abstract class DependencyVersion {
    public abstract boolean isCompatible(String var1) throws PackageException;

    public static DependencyVersion makeVersion(String versions, String semver, String min, String max) throws PackageException {
        if (versions != null) {
            DependencyVersion.checkNull(semver, "semver", "versions");
            DependencyVersion.checkNull(min, "semver-min", "versions");
            DependencyVersion.checkNull(max, "semver-max", "versions");
            return new DepVersions(versions);
        }
        if (semver != null) {
            DependencyVersion.checkNull(min, "semver-min", "semver");
            DependencyVersion.checkNull(max, "semver-max", "semver");
            return new DepSemver(semver);
        }
        if (min != null) {
            if (max == null) {
                return new DepSemverMin(min);
            }
            return new DepSemverMinMax(min, max);
        }
        if (max != null) {
            return new DepSemverMax(max);
        }
        return new DepNoVersion();
    }

    private static void checkNull(String val, String referee, String reference) throws PackageException {
        if (val != null) {
            throw new PackageException(referee + " cannot be set when " + reference + " is set");
        }
    }
}

