/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.IterableComparator;
import com.apple.foundationdb.tuple.TupleUtil;
import com.apple.foundationdb.tuple.Versionstamp;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Tuple
implements Comparable<Tuple>,
Iterable<Object> {
    private static final IterableComparator comparator = new IterableComparator();
    private static final byte[] EMPTY_BYTES = new byte[0];
    List<Object> elements;
    private byte[] packed = null;
    private int memoizedHash = 0;
    private int memoizedPackedSize = -1;
    private final boolean incompleteVersionstamp;

    private Tuple(Tuple tuple, Object object, boolean bl) {
        this.elements = new ArrayList<Object>(tuple.elements.size() + 1);
        this.elements.addAll(tuple.elements);
        this.elements.add(object);
        this.incompleteVersionstamp = tuple.incompleteVersionstamp || bl;
    }

    private Tuple(List<Object> list) {
        this.elements = list;
        this.incompleteVersionstamp = TupleUtil.hasIncompleteVersionstamp(list.stream());
    }

    public Tuple() {
        this.elements = Collections.emptyList();
        this.packed = EMPTY_BYTES;
        this.memoizedPackedSize = 0;
        this.incompleteVersionstamp = false;
    }

    public Tuple addObject(Object object) {
        if (!(object == null || object instanceof String || object instanceof byte[] || object instanceof UUID || object instanceof List || object instanceof Tuple || object instanceof Boolean || object instanceof Number || object instanceof Versionstamp)) {
            throw new IllegalArgumentException("Parameter type (" + object.getClass().getName() + ") not recognized");
        }
        return new Tuple(this, object, object instanceof Versionstamp && !((Versionstamp)object).isComplete() || object instanceof List && TupleUtil.hasIncompleteVersionstamp(((List)object).stream()) || object instanceof Tuple && ((Tuple)object).hasIncompleteVersionstamp());
    }

    public Tuple add(String string) {
        return new Tuple(this, string, false);
    }

    public Tuple add(long l) {
        return new Tuple(this, l, false);
    }

    public Tuple add(byte[] byArray) {
        return new Tuple(this, byArray, false);
    }

    public Tuple add(boolean bl) {
        return new Tuple(this, bl, false);
    }

    public Tuple add(UUID uUID) {
        return new Tuple(this, uUID, false);
    }

    public Tuple add(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullPointerException("Number types in Tuple cannot be null");
        }
        return new Tuple(this, bigInteger, false);
    }

    public Tuple add(float f) {
        return new Tuple(this, Float.valueOf(f), false);
    }

    public Tuple add(double d) {
        return new Tuple(this, d, false);
    }

    public Tuple add(Versionstamp versionstamp) {
        return new Tuple(this, versionstamp, !versionstamp.isComplete());
    }

    public Tuple add(List<?> list) {
        return new Tuple(this, list, TupleUtil.hasIncompleteVersionstamp(list.stream()));
    }

    public Tuple add(Tuple tuple) {
        return new Tuple(this, tuple, tuple.hasIncompleteVersionstamp());
    }

    public Tuple add(byte[] byArray, int n, int n2) {
        return new Tuple(this, Arrays.copyOfRange(byArray, n, n + n2), false);
    }

    public Tuple addAll(List<?> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + this.elements.size());
        arrayList.addAll(this.elements);
        arrayList.addAll(list);
        return new Tuple(arrayList);
    }

    public Tuple addAll(Tuple tuple) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.size() + tuple.size());
        arrayList.addAll(this.elements);
        arrayList.addAll(tuple.elements);
        Tuple tuple2 = new Tuple(arrayList);
        if (!tuple2.hasIncompleteVersionstamp() && this.packed != null && tuple.packed != null) {
            tuple2.packed = ByteArrayUtil.join(this.packed, tuple.packed);
        }
        if (this.memoizedPackedSize >= 0 && tuple.memoizedPackedSize >= 0) {
            tuple2.memoizedPackedSize = this.memoizedPackedSize + tuple.memoizedPackedSize;
        }
        return tuple2;
    }

    public byte[] pack() {
        return this.packInternal(null, true);
    }

    public byte[] pack(byte[] byArray) {
        return this.packInternal(byArray, true);
    }

    byte[] packInternal(byte[] byArray, boolean bl) {
        boolean bl2;
        if (this.hasIncompleteVersionstamp()) {
            throw new IllegalArgumentException("Incomplete Versionstamp included in vanilla tuple pack");
        }
        if (this.packed == null) {
            this.packed = TupleUtil.pack(this.elements, this.getPackedSize());
        }
        boolean bl3 = bl2 = byArray != null && byArray.length > 0;
        if (bl2) {
            return ByteArrayUtil.join(byArray, this.packed);
        }
        if (bl) {
            return Arrays.copyOf(this.packed, this.packed.length);
        }
        return this.packed;
    }

    public void packInto(ByteBuffer byteBuffer) {
        if (this.hasIncompleteVersionstamp()) {
            throw new IllegalArgumentException("Incomplete Versionstamp included in vanilla tuple pack");
        }
        if (this.packed == null) {
            TupleUtil.pack(byteBuffer, this.elements);
        } else {
            byteBuffer.put(this.packed);
        }
    }

    public byte[] packWithVersionstamp() {
        return this.packWithVersionstamp(null);
    }

    public byte[] packWithVersionstamp(byte[] byArray) {
        return this.packWithVersionstampInternal(byArray, true);
    }

    byte[] packWithVersionstampInternal(byte[] byArray, boolean bl) {
        boolean bl2;
        if (!this.hasIncompleteVersionstamp()) {
            throw new IllegalArgumentException("No incomplete Versionstamp included in tuple pack with versionstamp");
        }
        if (this.packed == null) {
            this.packed = TupleUtil.packWithVersionstamp(this.elements, this.getPackedSize());
        }
        boolean bl3 = bl2 = byArray != null && byArray.length > 0;
        if (bl2) {
            byte[] byArray2 = ByteArrayUtil.join(byArray, this.packed);
            TupleUtil.adjustVersionPosition(byArray2, byArray.length);
            return byArray2;
        }
        if (bl) {
            return Arrays.copyOf(this.packed, this.packed.length);
        }
        return this.packed;
    }

    byte[] packMaybeVersionstamp() {
        if (this.packed == null) {
            if (this.hasIncompleteVersionstamp()) {
                return this.packWithVersionstampInternal(null, false);
            }
            return this.packInternal(null, false);
        }
        return this.packed;
    }

    public List<Object> getItems() {
        return new ArrayList<Object>(this.elements);
    }

    public Stream<Object> stream() {
        return this.elements.stream();
    }

    @Override
    public Iterator<Object> iterator() {
        return Collections.unmodifiableList(this.elements).iterator();
    }

    public static Tuple fromBytes(byte[] byArray) {
        return Tuple.fromBytes(byArray, 0, byArray.length);
    }

    public static Tuple fromBytes(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length) {
            throw new IllegalArgumentException("Invalid offset for Tuple deserialization");
        }
        if (n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid length for Tuple deserialization");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, n + n2);
        Tuple tuple = new Tuple(TupleUtil.unpack(byArray2));
        tuple.packed = byArray2;
        tuple.memoizedPackedSize = n2;
        return tuple;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public long getLong(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            throw new NullPointerException("Number types in Tuples may not be null");
        }
        return ((Number)object).longValue();
    }

    public byte[] getBytes(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            return null;
        }
        return (byte[])object;
    }

    public String getString(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public BigInteger getBigInteger(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            throw new NullPointerException("Number types in Tuples may not be null");
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        return BigInteger.valueOf(((Number)object).longValue());
    }

    public float getFloat(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            throw new NullPointerException("Number types in Tuples may not be null");
        }
        return ((Number)object).floatValue();
    }

    public double getDouble(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            throw new NullPointerException("Number types in Tuples may not be null");
        }
        return ((Number)object).doubleValue();
    }

    public boolean getBoolean(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            throw new NullPointerException("Boolean type in Tuples may not be null");
        }
        return (Boolean)object;
    }

    public UUID getUUID(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            return null;
        }
        return (UUID)object;
    }

    public Versionstamp getVersionstamp(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            return null;
        }
        return (Versionstamp)object;
    }

    public List<Object> getNestedList(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Tuple) {
            return ((Tuple)object).getItems();
        }
        if (object instanceof List) {
            return new ArrayList<Object>((List)object);
        }
        throw new ClassCastException("Cannot convert item of type " + object.getClass() + " to list");
    }

    public Tuple getNestedTuple(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Tuple) {
            return (Tuple)object;
        }
        if (object instanceof List) {
            return Tuple.fromList((List)object);
        }
        throw new ClassCastException("Cannot convert item of type " + object.getClass() + " to tuple");
    }

    public Object get(int n) {
        return this.elements.get(n);
    }

    public Tuple popFront() {
        if (this.elements.isEmpty()) {
            throw new IllegalStateException("Tuple contains no elements");
        }
        return new Tuple(this.elements.subList(1, this.elements.size()));
    }

    public Tuple popBack() {
        if (this.elements.isEmpty()) {
            throw new IllegalStateException("Tuple contains no elements");
        }
        return new Tuple(this.elements.subList(0, this.elements.size() - 1));
    }

    public Range range() {
        return this.range(null);
    }

    public Range range(byte[] byArray) {
        if (this.hasIncompleteVersionstamp()) {
            throw new IllegalStateException("Tuple with incomplete versionstamp used for range");
        }
        byte[] byArray2 = this.packInternal(byArray, false);
        return new Range(ByteArrayUtil.join(byArray2, {0}), ByteArrayUtil.join(byArray2, {-1}));
    }

    public boolean hasIncompleteVersionstamp() {
        return this.incompleteVersionstamp;
    }

    public int getPackedSize() {
        if (this.memoizedPackedSize < 0) {
            this.memoizedPackedSize = this.getPackedSize(false);
        }
        return this.memoizedPackedSize;
    }

    int getPackedSize(boolean bl) {
        if (this.memoizedPackedSize >= 0) {
            if (!bl) {
                return this.memoizedPackedSize;
            }
            int n = 0;
            for (Object object : this.elements) {
                if (object != null) continue;
                ++n;
            }
            return this.memoizedPackedSize + n;
        }
        return TupleUtil.getPackedSize(this.elements, bl);
    }

    @Override
    public int compareTo(Tuple tuple) {
        if (this.packed != null && tuple.packed != null && !this.hasIncompleteVersionstamp() && !tuple.hasIncompleteVersionstamp()) {
            return ByteArrayUtil.compareUnsigned(this.packed, tuple.packed);
        }
        return comparator.compare((Iterable<?>)this.elements, (Iterable<?>)tuple.elements);
    }

    public int hashCode() {
        if (this.memoizedHash == 0) {
            this.memoizedHash = Arrays.hashCode(this.packMaybeVersionstamp());
        }
        return this.memoizedHash;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Tuple) {
            return this.compareTo((Tuple)object) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        boolean bl = true;
        for (Object object : this.elements) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            if (object == null) {
                stringBuilder.append("null");
                continue;
            }
            if (object instanceof String) {
                stringBuilder.append("\"");
                stringBuilder.append(object);
                stringBuilder.append("\"");
                continue;
            }
            if (object instanceof byte[]) {
                stringBuilder.append("b\"");
                stringBuilder.append(ByteArrayUtil.printable((byte[])object));
                stringBuilder.append("\"");
                continue;
            }
            stringBuilder.append(object);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Tuple fromItems(Iterable<?> iterable) {
        if (iterable instanceof List) {
            return Tuple.fromList((List)iterable);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object obj : iterable) {
            arrayList.add(obj);
        }
        return new Tuple(arrayList);
    }

    public static Tuple fromList(List<?> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list);
        return new Tuple(arrayList);
    }

    public static Tuple fromStream(Stream<?> stream) {
        return new Tuple(stream.collect(Collectors.toList()));
    }

    public static Tuple from(Object ... objectArray) {
        return new Tuple(Arrays.asList(objectArray));
    }

    static void main(String[] stringArray) {
        Tuple tuple;
        Object object22;
        for (int byArray : new int[]{10, 100, 1000, 10000, 100000, 1000000}) {
            Tuple.createTuple(byArray);
        }
        Versionstamp versionstamp = Versionstamp.complete(new byte[]{15, -37, 15, -37, 15, -37, 15, -37, 15, -37}, 15);
        Versionstamp versionstamp2 = Versionstamp.incomplete(20);
        Tuple tuple2 = new Tuple();
        tuple2 = tuple2.add(Long.MAX_VALUE);
        tuple2 = tuple2.add(0x7FFFFFFFFFFFFFFEL);
        tuple2 = tuple2.add(0x7FFFFFFFFFFFFFFDL);
        tuple2 = tuple2.add(1L);
        tuple2 = tuple2.add(0L);
        tuple2 = tuple2.add(-1L);
        tuple2 = tuple2.add(-9223372036854775806L);
        tuple2 = tuple2.add(-9223372036854775807L);
        tuple2 = tuple2.add(Long.MIN_VALUE);
        tuple2 = tuple2.add("foo");
        tuple2 = tuple2.addObject(null);
        tuple2 = tuple2.add(false);
        tuple2 = tuple2.add(true);
        tuple2 = tuple2.add(3.14159);
        tuple2 = tuple2.add(3.14159f);
        tuple2 = tuple2.add(UUID.randomUUID());
        tuple2 = tuple2.add(tuple2.getItems());
        tuple2 = tuple2.add(tuple2);
        tuple2 = tuple2.add(new BigInteger("100000000000000000000000000000000000000000000"));
        tuple2 = tuple2.add(new BigInteger("-100000000000000000000000000000000000000000000"));
        tuple2 = tuple2.add(versionstamp);
        byte[] byArray = tuple2.pack();
        System.out.println("Packed: " + ByteArrayUtil.printable(byArray));
        List<Object> list = Tuple.fromBytes(byArray).getItems();
        for (Object n : list) {
            if (n != null) {
                System.out.println(" -> type: (" + n.getClass().getName() + "): " + n);
                continue;
            }
            System.out.println(" -> type: (null): null");
        }
        tuple2 = Tuple.fromStream(tuple2.stream().map(object -> {
            if (object instanceof String) {
                return ((String)object).toUpperCase();
            }
            return object;
        }));
        System.out.println("Upper cased: " + tuple2);
        Tuple tuple3 = Tuple.fromBytes(byArray);
        System.out.println("t2.getLong(0): " + tuple3.getLong(0));
        System.out.println("t2.getBigInteger(1): " + tuple3.getBigInteger(1));
        System.out.println("t2.getString(9): " + tuple3.getString(9));
        System.out.println("t2.get(10): " + tuple3.get(10));
        System.out.println("t2.getBoolean(11): " + tuple3.getBoolean(11));
        System.out.println("t2.getBoolean(12): " + tuple3.getBoolean(12));
        System.out.println("t2.getDouble(13): " + tuple3.getDouble(13));
        System.out.println("t2.getFloat(13): " + tuple3.getFloat(13));
        System.out.println("t2.getLong(13): " + tuple3.getLong(13));
        System.out.println("t2.getBigInteger(13): " + tuple3.getBigInteger(13));
        System.out.println("t2.getDouble(14): " + tuple3.getDouble(14));
        System.out.println("t2.getFloat(14): " + tuple3.getFloat(14));
        System.out.println("t2.getLong(14): " + tuple3.getLong(14));
        System.out.println("t2.getBigInteger(14): " + tuple3.getBigInteger(14));
        System.out.println("t2.getNestedList(17): " + tuple3.getNestedList(17));
        System.out.println("t2.getNestedTuple(17): " + tuple3.getNestedTuple(17));
        System.out.println("t2.getVersionstamp(20): " + tuple3.getVersionstamp(20));
        int n = 0;
        for (Object object22 : tuple2) {
            int tuple5 = Tuple.from(object22).pack().length;
            tuple = Tuple.fromBytes(byArray, n, tuple5);
            System.out.println("item = " + tuple);
            n += tuple5;
        }
        System.out.println("(2*(Long.MAX_VALUE+1),) = " + ByteArrayUtil.printable(Tuple.from(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE).shiftLeft(1)).pack()));
        System.out.println("(2*Long.MIN_VALUE,) = " + ByteArrayUtil.printable(Tuple.from(BigInteger.valueOf(Long.MIN_VALUE).multiply(new BigInteger("2"))).pack()));
        System.out.println("2*Long.MIN_VALUE = " + Tuple.fromBytes(Tuple.from(BigInteger.valueOf(Long.MIN_VALUE).multiply(new BigInteger("2"))).pack()).getBigInteger(0));
        Tuple tuple4 = Tuple.from("complete:", versionstamp, 1);
        System.out.println("vt1: " + tuple4 + " ; has incomplete: " + tuple4.hasIncompleteVersionstamp());
        object22 = Tuple.from("incomplete:", versionstamp2, 2);
        System.out.println("vt2: " + object22 + " ; has incomplete: " + ((Tuple)object22).hasIncompleteVersionstamp());
        Tuple tuple5 = Tuple.from("complete nested: ", tuple4, 3);
        System.out.println("vt3: " + tuple5 + " ; has incomplete: " + tuple5.hasIncompleteVersionstamp());
        tuple = Tuple.from("incomplete nested: ", object22, 4);
        System.out.println("vt4: " + tuple + " ; has incomplete: " + tuple.hasIncompleteVersionstamp());
        Tuple tuple6 = Tuple.from("complete with null: ", null, versionstamp, 5);
        System.out.println("vt5: " + tuple6 + " ; has incomplete: " + tuple6.hasIncompleteVersionstamp());
        Tuple tuple7 = Tuple.from("complete with null: ", null, versionstamp2, 6);
        System.out.println("vt6: " + tuple7 + " ; has incomplete: " + tuple7.hasIncompleteVersionstamp());
    }

    private static Tuple createTuple(int n) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new byte[]{99});
        }
        long l = System.currentTimeMillis();
        Tuple tuple = Tuple.fromList(arrayList);
        tuple.pack();
        System.out.println("Took " + (System.currentTimeMillis() - l) + " ms for " + n + " (" + arrayList.size() + ")");
        return tuple;
    }
}

