/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async;

import com.apple.foundationdb.FDB;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AsyncUtil {
    public static final CompletableFuture<Void> DONE = CompletableFuture.completedFuture(null);
    public static final CompletableFuture<Boolean> READY_TRUE = CompletableFuture.completedFuture(Boolean.TRUE);
    public static final CompletableFuture<Boolean> READY_FALSE = CompletableFuture.completedFuture(Boolean.FALSE);

    public static <I, O> CompletableFuture<O> applySafely(Function<I, ? extends CompletableFuture<O>> function, I i) {
        try {
            return function.apply(i);
        }
        catch (RuntimeException runtimeException) {
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally(runtimeException);
            return completableFuture;
        }
    }

    public static <V> CompletableFuture<Void> forEach(AsyncIterable<V> asyncIterable, Consumer<? super V> consumer) {
        return AsyncUtil.forEachRemaining(asyncIterable.iterator(), consumer);
    }

    public static <V> CompletableFuture<Void> forEach(AsyncIterable<V> asyncIterable, Consumer<? super V> consumer, Executor executor) {
        return AsyncUtil.forEachRemaining(asyncIterable.iterator(), consumer, executor);
    }

    public static <V> CompletableFuture<Void> forEachRemaining(AsyncIterator<V> asyncIterator, Consumer<? super V> consumer) {
        return AsyncUtil.forEachRemaining(asyncIterator, consumer, FDB.DEFAULT_EXECUTOR);
    }

    public static <V> CompletableFuture<Void> forEachRemaining(AsyncIterator<V> asyncIterator, Consumer<? super V> consumer, Executor executor) {
        return asyncIterator.onHasNext().thenComposeAsync(bl -> {
            if (bl.booleanValue()) {
                return AsyncUtil.whileTrue(() -> {
                    consumer.accept((Object)asyncIterator.next());
                    return asyncIterator.onHasNext();
                }, executor);
            }
            return DONE;
        }, executor);
    }

    public static <V> CompletableFuture<List<V>> collect(AsyncIterable<V> asyncIterable) {
        return AsyncUtil.collect(asyncIterable, FDB.DEFAULT_EXECUTOR);
    }

    public static <V> CompletableFuture<List<V>> collectRemaining(AsyncIterator<V> asyncIterator) {
        return AsyncUtil.collectRemaining(asyncIterator, FDB.DEFAULT_EXECUTOR);
    }

    public static <V> CompletableFuture<List<V>> collect(AsyncIterable<V> asyncIterable, Executor executor) {
        return AsyncUtil.collectRemaining(asyncIterable.iterator(), executor);
    }

    public static <V> CompletableFuture<List<V>> collectRemaining(AsyncIterator<V> asyncIterator, Executor executor) {
        LinkedList linkedList = new LinkedList();
        return AsyncUtil.tag(AsyncUtil.forEachRemaining(asyncIterator, linkedList::add, executor), linkedList);
    }

    public static <V, T> AsyncIterable<T> mapIterable(final AsyncIterable<V> asyncIterable, final Function<V, T> function) {
        return new AsyncIterable<T>(){

            @Override
            public AsyncIterator<T> iterator() {
                return AsyncUtil.mapIterator(asyncIterable.iterator(), function);
            }

            @Override
            public CompletableFuture<List<T>> asList() {
                LinkedList linkedList = new LinkedList();
                return AsyncUtil.tag(AsyncUtil.forEach(asyncIterable, object -> linkedList.add(function.apply(object))), linkedList);
            }
        };
    }

    public static <V, T> AsyncIterator<T> mapIterator(final AsyncIterator<V> asyncIterator, final Function<V, T> function) {
        return new AsyncIterator<T>(){

            @Override
            public void remove() {
                asyncIterator.remove();
            }

            @Override
            public CompletableFuture<Boolean> onHasNext() {
                return asyncIterator.onHasNext();
            }

            @Override
            public boolean hasNext() {
                return asyncIterator.hasNext();
            }

            @Override
            public T next() {
                return function.apply(asyncIterator.next());
            }

            @Override
            public void cancel() {
                asyncIterator.cancel();
            }
        };
    }

    public static <V, T> CloseableAsyncIterator<T> mapIterator(final CloseableAsyncIterator<V> closeableAsyncIterator, final Function<V, T> function) {
        return new CloseableAsyncIterator<T>(){

            @Override
            public void remove() {
                closeableAsyncIterator.remove();
            }

            @Override
            public CompletableFuture<Boolean> onHasNext() {
                return closeableAsyncIterator.onHasNext();
            }

            @Override
            public boolean hasNext() {
                return closeableAsyncIterator.hasNext();
            }

            @Override
            public T next() {
                return function.apply(closeableAsyncIterator.next());
            }

            @Override
            public void cancel() {
                closeableAsyncIterator.cancel();
            }

            @Override
            public void close() {
                closeableAsyncIterator.close();
            }
        };
    }

    @Deprecated
    public static CompletableFuture<Void> whileTrue(Function<Void, ? extends CompletableFuture<Boolean>> function) {
        return AsyncUtil.whileTrue(function, (Executor)FDB.DEFAULT_EXECUTOR);
    }

    @Deprecated
    public static CompletableFuture<Void> whileTrue(Function<Void, ? extends CompletableFuture<Boolean>> function, Executor executor) {
        return AsyncUtil.whileTrue(() -> (CompletableFuture)function.apply(null), executor);
    }

    public static CompletableFuture<Void> whileTrue(Supplier<CompletableFuture<Boolean>> supplier) {
        return AsyncUtil.whileTrue(supplier, (Executor)FDB.DEFAULT_EXECUTOR);
    }

    public static CompletableFuture<Void> whileTrue(Supplier<CompletableFuture<Boolean>> supplier, Executor executor) {
        return new LoopPartial(supplier, executor).run();
    }

    public static <V> CompletableFuture<Void> success(CompletableFuture<V> completableFuture) {
        return completableFuture.thenApply(object -> null);
    }

    public static <V> CompletableFuture<Void> whenReady(CompletableFuture<V> completableFuture) {
        return completableFuture.handle((object, throwable) -> null);
    }

    public static <V> CompletableFuture<V> composeExceptionally(CompletableFuture<V> completableFuture, Function<Throwable, CompletableFuture<V>> function) {
        return ((CompletableFuture)completableFuture.handle((object, throwable) -> throwable)).thenCompose(throwable -> {
            if (throwable != null) {
                return (CompletionStage)function.apply((Throwable)throwable);
            }
            return completableFuture;
        });
    }

    public static <V, T> CompletableFuture<T> composeHandle(CompletableFuture<V> completableFuture, BiFunction<V, Throwable, ? extends CompletableFuture<T>> biFunction) {
        return ((CompletableFuture)completableFuture.handle(biFunction)).thenCompose(Function.identity());
    }

    public static <V, T> CompletableFuture<T> composeHandleAsync(CompletableFuture<V> completableFuture, BiFunction<V, Throwable, ? extends CompletableFuture<T>> biFunction) {
        return AsyncUtil.composeHandleAsync(completableFuture, biFunction, FDB.DEFAULT_EXECUTOR);
    }

    public static <V, T> CompletableFuture<T> composeHandleAsync(CompletableFuture<V> completableFuture, BiFunction<V, Throwable, ? extends CompletableFuture<T>> biFunction, Executor executor) {
        return ((CompletableFuture)completableFuture.handleAsync(biFunction, executor)).thenCompose(Function.identity());
    }

    public static <V> CompletableFuture<List<V>> getAll(Collection<CompletableFuture<V>> collection) {
        return AsyncUtil.whenAll(collection).thenApply(void_ -> {
            ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
            for (CompletableFuture completableFuture : collection) {
                assert (completableFuture.isDone());
                arrayList.add(completableFuture.getNow(null));
            }
            return arrayList;
        });
    }

    public static <V, T> CompletableFuture<V> tag(CompletableFuture<T> completableFuture, V v) {
        return completableFuture.thenApply(object2 -> v);
    }

    public static <V> CompletableFuture<Void> whenAny(Collection<? extends CompletableFuture<V>> collection) {
        CompletableFuture[] completableFutureArray = collection.toArray(new CompletableFuture[collection.size()]);
        CompletableFuture<Object> completableFuture = CompletableFuture.anyOf(completableFutureArray);
        return AsyncUtil.success(completableFuture);
    }

    public static <V> CompletableFuture<Void> whenAll(Collection<? extends CompletableFuture<V>> collection) {
        CompletableFuture[] completableFutureArray = collection.toArray(new CompletableFuture[collection.size()]);
        return CompletableFuture.allOf(completableFutureArray);
    }

    private AsyncUtil() {
    }

    private static class LoopPartial
    implements BiFunction<Boolean, Throwable, Void> {
        final Supplier<? extends CompletableFuture<Boolean>> body;
        final CompletableFuture<Void> done;
        final Executor executor;

        LoopPartial(Supplier<? extends CompletableFuture<Boolean>> supplier, Executor executor) {
            this.body = supplier;
            this.done = new CompletableFuture();
            this.executor = executor;
        }

        @Override
        public Void apply(Boolean bl, Throwable throwable) {
            block7: {
                if (throwable != null) {
                    this.done.completeExceptionally(throwable);
                } else {
                    CompletableFuture<Boolean> completableFuture;
                    while (true) {
                        if (!bl.booleanValue()) {
                            this.done.complete(null);
                            break block7;
                        }
                        try {
                            completableFuture = this.body.get();
                        }
                        catch (Exception exception) {
                            this.done.completeExceptionally(exception);
                            break block7;
                        }
                        if (!completableFuture.isDone()) break;
                        if (completableFuture.isCompletedExceptionally()) {
                            completableFuture.handle((BiFunction)this);
                            break block7;
                        }
                        bl = completableFuture.join();
                    }
                    completableFuture.handleAsync((BiFunction)this, this.executor);
                }
            }
            return null;
        }

        public CompletableFuture<Void> run() {
            this.apply(true, null);
            return this.done;
        }
    }
}

