/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class TenantManagement {
    static final byte[] TENANT_MAP_PREFIX = ByteArrayUtil.join({-1, -1}, "/management/tenant_map/".getBytes());

    public static void createTenant(Transaction transaction, byte[] byArray) {
        transaction.options().setSpecialKeySpaceEnableWrites();
        transaction.set(ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray), new byte[0]);
    }

    public static void createTenant(Transaction transaction, Tuple tuple) {
        TenantManagement.createTenant(transaction, tuple.pack());
    }

    public static CompletableFuture<Void> createTenant(Database database, byte[] byArray) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        byte[] byArray2 = ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray);
        return database.runAsync(transaction -> {
            transaction.options().setSpecialKeySpaceEnableWrites();
            if (atomicBoolean.get()) {
                transaction.set(byArray2, new byte[0]);
                return CompletableFuture.completedFuture(null);
            }
            return transaction.get(byArray2).thenAcceptAsync(byArray2 -> {
                atomicBoolean.set(true);
                if (byArray2 != null) {
                    throw new FDBException("A tenant with the given name already exists", 2132);
                }
                transaction.set(byArray2, new byte[0]);
            });
        });
    }

    public static CompletableFuture<Void> createTenant(Database database, Tuple tuple) {
        return TenantManagement.createTenant(database, tuple.pack());
    }

    public static void deleteTenant(Transaction transaction, byte[] byArray) {
        transaction.options().setSpecialKeySpaceEnableWrites();
        transaction.clear(ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray));
    }

    public static void deleteTenant(Transaction transaction, Tuple tuple) {
        TenantManagement.deleteTenant(transaction, tuple.pack());
    }

    public static CompletableFuture<Void> deleteTenant(Database database, byte[] byArray) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        byte[] byArray2 = ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray);
        return database.runAsync(transaction -> {
            transaction.options().setSpecialKeySpaceEnableWrites();
            if (atomicBoolean.get()) {
                transaction.clear(byArray2);
                return CompletableFuture.completedFuture(null);
            }
            return transaction.get(byArray2).thenAcceptAsync(byArray2 -> {
                atomicBoolean.set(true);
                if (byArray2 == null) {
                    throw new FDBException("Tenant does not exist", 2131);
                }
                transaction.clear(byArray2);
            });
        });
    }

    public static CompletableFuture<Void> deleteTenant(Database database, Tuple tuple) {
        return TenantManagement.deleteTenant(database, tuple.pack());
    }

    private TenantManagement() {
    }
}

