/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FDBTransaction;
import com.apple.foundationdb.FutureBool;
import com.apple.foundationdb.FutureInt64;
import com.apple.foundationdb.FutureKey;
import com.apple.foundationdb.FutureKeyRangeArray;
import com.apple.foundationdb.FutureVoid;
import com.apple.foundationdb.KeyRangeArrayResult;
import com.apple.foundationdb.NativeObjectWrapper;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Tenant;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

class FDBTenant
extends NativeObjectWrapper
implements Tenant {
    private final Database database;
    private final byte[] name;
    private final Executor executor;
    private final EventKeeper eventKeeper;

    protected FDBTenant(long l, Database database, byte[] byArray, Executor executor) {
        this(l, database, byArray, executor, null);
    }

    protected FDBTenant(long l, Database database, byte[] byArray, Executor executor, EventKeeper eventKeeper) {
        super(l);
        this.database = database;
        this.name = byArray;
        this.executor = executor;
        this.eventKeeper = eventKeeper;
    }

    @Override
    public <T> T run(Function<? super Transaction, T> function, Executor executor) {
        Transaction transaction = this.createTransaction(executor);
        while (true) {
            try {
                T t = function.apply(transaction);
                transaction.commit().join();
                T t2 = t;
                return t2;
            }
            catch (RuntimeException runtimeException) {
                transaction = transaction.onError(runtimeException).join();
                continue;
            }
            break;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public <T> T read(Function<? super ReadTransaction, T> function, Executor executor) {
        return this.run(function, executor);
    }

    @Override
    public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> function, Executor executor) {
        AtomicReference<Transaction> atomicReference = new AtomicReference<Transaction>(this.createTransaction(executor));
        AtomicReference atomicReference2 = new AtomicReference();
        return ((CompletableFuture)AsyncUtil.whileTrue(() -> {
            CompletableFuture completableFuture = AsyncUtil.applySafely(function, atomicReference.get());
            return AsyncUtil.composeHandleAsync(completableFuture.thenComposeAsync(object -> ((Transaction)atomicReference.get()).commit().thenApply(void_ -> {
                atomicReference2.set(object);
                return false;
            }), executor), (bl, throwable) -> {
                if (throwable == null) {
                    return CompletableFuture.completedFuture(bl);
                }
                if (!(throwable instanceof RuntimeException)) {
                    throw new CompletionException((Throwable)throwable);
                }
                return ((Transaction)atomicReference.get()).onError((Throwable)throwable).thenApply(transaction -> {
                    atomicReference.set((Transaction)transaction);
                    return true;
                });
            }, executor);
        }, executor).thenApply(void_ -> atomicReference2.get())).whenComplete((object, throwable) -> ((Transaction)atomicReference.get()).close());
    }

    @Override
    public <T> CompletableFuture<T> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<T>> function, Executor executor) {
        return this.runAsync(function, executor);
    }

    protected void finalize() throws Throwable {
        try {
            this.checkUnclosed("Tenant");
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Transaction createTransaction(Executor executor) {
        return this.createTransaction(executor, this.eventKeeper);
    }

    @Override
    public Transaction createTransaction(Executor executor, EventKeeper eventKeeper) {
        this.pointerReadLock.lock();
        Transaction transaction = null;
        try {
            transaction = new FDBTransaction(this.Tenant_createTransaction(this.getPtr()), this.database, executor, eventKeeper);
            transaction.options().setUsedDuringCommitProtectionDisable();
            Transaction transaction2 = transaction;
            return transaction2;
        }
        catch (RuntimeException runtimeException) {
            if (transaction != null) {
                transaction.close();
            }
            throw runtimeException;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<byte[]> purgeBlobGranules(byte[] byArray, byte[] byArray2, long l, boolean bl, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureKey futureKey = new FutureKey(this.Tenant_purgeBlobGranules(this.getPtr(), byArray, byArray2, l, bl), executor, this.eventKeeper);
            return futureKey;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> waitPurgeGranulesComplete(byte[] byArray, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureVoid futureVoid = new FutureVoid(this.Tenant_waitPurgeGranulesComplete(this.getPtr(), byArray), executor);
            return futureVoid;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> blobbifyRange(byte[] byArray, byte[] byArray2, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureBool futureBool = new FutureBool(this.Tenant_blobbifyRange(this.getPtr(), byArray, byArray2), executor);
            return futureBool;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> unblobbifyRange(byte[] byArray, byte[] byArray2, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureBool futureBool = new FutureBool(this.Tenant_unblobbifyRange(this.getPtr(), byArray, byArray2), executor);
            return futureBool;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<KeyRangeArrayResult> listBlobbifiedRanges(byte[] byArray, byte[] byArray2, int n, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureKeyRangeArray futureKeyRangeArray = new FutureKeyRangeArray(this.Tenant_listBlobbifiedRanges(this.getPtr(), byArray, byArray2, n), executor);
            return futureKeyRangeArray;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Long> verifyBlobRange(byte[] byArray, byte[] byArray2, long l, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureInt64 futureInt64 = new FutureInt64(this.Tenant_verifyBlobRange(this.getPtr(), byArray, byArray2, l), executor);
            return futureInt64;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public byte[] getName() {
        return this.name;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    protected void closeInternal(long l) {
        this.Tenant_dispose(l);
    }

    private native long Tenant_createTransaction(long var1);

    private native void Tenant_dispose(long var1);

    private native long Tenant_purgeBlobGranules(long var1, byte[] var3, byte[] var4, long var5, boolean var7);

    private native long Tenant_waitPurgeGranulesComplete(long var1, byte[] var3);

    private native long Tenant_blobbifyRange(long var1, byte[] var3, byte[] var4);

    private native long Tenant_unblobbifyRange(long var1, byte[] var3, byte[] var4);

    private native long Tenant_listBlobbifiedRanges(long var1, byte[] var3, byte[] var4, int var5);

    private native long Tenant_verifyBlobRange(long var1, byte[] var3, byte[] var4, long var5);
}

