/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.FDBException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class NativeFuture<T>
extends CompletableFuture<T>
implements AutoCloseable {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final Lock pointerReadLock = this.rwl.readLock();
    private long cPtr;

    protected NativeFuture(long l) {
        this.cPtr = l;
    }

    protected void registerMarshalCallback(Executor executor) {
        if (this.cPtr != 0L) {
            this.Future_registerCallback(this.cPtr, () -> executor.execute(this::marshalWhenDone));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshalWhenDone() {
        T t = null;
        try {
            boolean bl = false;
            try {
                this.pointerReadLock.lock();
                if (this.cPtr != 0L) {
                    t = this.getIfDone_internal(this.cPtr);
                    bl = true;
                }
            }
            finally {
                this.pointerReadLock.unlock();
            }
            if (bl) {
                this.complete(t);
            }
        }
        catch (FDBException fDBException) {
            assert (fDBException.getCode() != 1102 && fDBException.getCode() != 2015);
            this.completeExceptionally(fDBException);
        }
        catch (Throwable throwable) {
            this.completeExceptionally(throwable);
        }
        finally {
            this.postMarshal(t);
        }
    }

    protected void postMarshal(T t) {
        this.close();
    }

    protected abstract T getIfDone_internal(long var1) throws FDBException;

    @Override
    public void close() {
        long l = 0L;
        this.rwl.writeLock().lock();
        if (this.cPtr != 0L) {
            l = this.cPtr;
            this.cPtr = 0L;
        }
        this.rwl.writeLock().unlock();
        if (l != 0L) {
            this.Future_dispose(l);
            if (!this.isDone()) {
                this.completeExceptionally(new IllegalStateException("Future has been closed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = super.cancel(bl);
        try {
            this.rwl.readLock().lock();
            if (this.cPtr != 0L) {
                this.Future_cancel(this.cPtr);
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    protected long getPtr() {
        assert (this.rwl.getReadHoldCount() > 0);
        if (this.cPtr == 0L) {
            throw new IllegalStateException("Cannot access closed object");
        }
        return this.cPtr;
    }

    private native void Future_registerCallback(long var1, Runnable var3);

    private native void Future_blockUntilReady(long var1);

    private native boolean Future_isReady(long var1);

    private native void Future_dispose(long var1);

    private native void Future_cancel(long var1);

    private native void Future_releaseMemory(long var1);

    protected native FDBException Future_getError(long var1);
}

