/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.KeyRangeArrayResult;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;

public interface Tenant
extends AutoCloseable,
TransactionContext {
    default public Transaction createTransaction() {
        return this.createTransaction(this.getExecutor());
    }

    public Transaction createTransaction(Executor var1);

    public Transaction createTransaction(Executor var1, EventKeeper var2);

    public byte[] getName();

    @Override
    default public <T> T read(Function<? super ReadTransaction, T> function) {
        return this.read(function, this.getExecutor());
    }

    public <T> T read(Function<? super ReadTransaction, T> var1, Executor var2);

    @Override
    default public <T> CompletableFuture<T> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<T>> function) {
        return this.readAsync(function, this.getExecutor());
    }

    public <T> CompletableFuture<T> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<T>> var1, Executor var2);

    @Override
    default public <T> T run(Function<? super Transaction, T> function) {
        return this.run(function, this.getExecutor());
    }

    public <T> T run(Function<? super Transaction, T> var1, Executor var2);

    @Override
    default public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> function) {
        return this.runAsync(function, this.getExecutor());
    }

    public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> var1, Executor var2);

    default public CompletableFuture<byte[]> purgeBlobGranules(byte[] byArray, byte[] byArray2, boolean bl) {
        return this.purgeBlobGranules(byArray, byArray2, -2L, bl, this.getExecutor());
    }

    default public CompletableFuture<byte[]> purgeBlobGranules(byte[] byArray, byte[] byArray2, long l, boolean bl) {
        return this.purgeBlobGranules(byArray, byArray2, l, bl, this.getExecutor());
    }

    public CompletableFuture<byte[]> purgeBlobGranules(byte[] var1, byte[] var2, long var3, boolean var5, Executor var6);

    default public CompletableFuture<Void> waitPurgeGranulesComplete(byte[] byArray) {
        return this.waitPurgeGranulesComplete(byArray, this.getExecutor());
    }

    public CompletableFuture<Void> waitPurgeGranulesComplete(byte[] var1, Executor var2);

    default public CompletableFuture<Boolean> blobbifyRange(byte[] byArray, byte[] byArray2) {
        return this.blobbifyRange(byArray, byArray2, this.getExecutor());
    }

    public CompletableFuture<Boolean> blobbifyRange(byte[] var1, byte[] var2, Executor var3);

    default public CompletableFuture<Boolean> unblobbifyRange(byte[] byArray, byte[] byArray2) {
        return this.unblobbifyRange(byArray, byArray2, this.getExecutor());
    }

    public CompletableFuture<Boolean> unblobbifyRange(byte[] var1, byte[] var2, Executor var3);

    default public CompletableFuture<KeyRangeArrayResult> listBlobbifiedRanges(byte[] byArray, byte[] byArray2, int n) {
        return this.listBlobbifiedRanges(byArray, byArray2, n, this.getExecutor());
    }

    public CompletableFuture<KeyRangeArrayResult> listBlobbifiedRanges(byte[] var1, byte[] var2, int var3, Executor var4);

    default public CompletableFuture<Long> verifyBlobRange(byte[] byArray, byte[] byArray2) {
        return this.verifyBlobRange(byArray, byArray2, -2L, this.getExecutor());
    }

    default public CompletableFuture<Long> verifyBlobRange(byte[] byArray, byte[] byArray2, long l) {
        return this.verifyBlobRange(byArray, byArray2, l, this.getExecutor());
    }

    public CompletableFuture<Long> verifyBlobRange(byte[] var1, byte[] var2, long var3, Executor var5);

    @Override
    public void close();
}

