/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class TenantManagement {
    static byte[] TENANT_MAP_PREFIX = ByteArrayUtil.join({-1, -1}, "/management/tenant/map/".getBytes());

    public static void createTenant(Transaction transaction, byte[] byArray) {
        transaction.options().setSpecialKeySpaceEnableWrites();
        transaction.set(ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray), new byte[0]);
    }

    public static void createTenant(Transaction transaction, Tuple tuple) {
        TenantManagement.createTenant(transaction, tuple.pack());
    }

    public static CompletableFuture<Void> createTenant(Database database, byte[] byArray) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        byte[] byArray2 = ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray);
        return database.runAsync(transaction -> {
            transaction.options().setSpecialKeySpaceEnableWrites();
            if (atomicBoolean.get()) {
                transaction.set(byArray2, new byte[0]);
                return CompletableFuture.completedFuture(null);
            }
            return transaction.get(byArray2).thenAcceptAsync(byArray2 -> {
                atomicBoolean.set(true);
                if (byArray2 != null) {
                    throw new FDBException("A tenant with the given name already exists", 2132);
                }
                transaction.set(byArray2, new byte[0]);
            });
        });
    }

    public static CompletableFuture<Void> createTenant(Database database, Tuple tuple) {
        return TenantManagement.createTenant(database, tuple.pack());
    }

    public static void deleteTenant(Transaction transaction, byte[] byArray) {
        transaction.options().setSpecialKeySpaceEnableWrites();
        transaction.clear(ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray));
    }

    public static void deleteTenant(Transaction transaction, Tuple tuple) {
        TenantManagement.deleteTenant(transaction, tuple.pack());
    }

    public static CompletableFuture<Void> deleteTenant(Database database, byte[] byArray) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        byte[] byArray2 = ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray);
        return database.runAsync(transaction -> {
            transaction.options().setSpecialKeySpaceEnableWrites();
            if (atomicBoolean.get()) {
                transaction.clear(byArray2);
                return CompletableFuture.completedFuture(null);
            }
            return transaction.get(byArray2).thenAcceptAsync(byArray2 -> {
                atomicBoolean.set(true);
                if (byArray2 == null) {
                    throw new FDBException("Tenant does not exist", 2131);
                }
                transaction.clear(byArray2);
            });
        });
    }

    public static CompletableFuture<Void> deleteTenant(Database database, Tuple tuple) {
        return TenantManagement.deleteTenant(database, tuple.pack());
    }

    public static CloseableAsyncIterator<KeyValue> listTenants(Database database, byte[] byArray, byte[] byArray2, int n) {
        return TenantManagement.listTenants_internal(database.createTransaction(), byArray, byArray2, n);
    }

    public static CloseableAsyncIterator<KeyValue> listTenants(Database database, Tuple tuple, Tuple tuple2, int n) {
        return TenantManagement.listTenants_internal(database.createTransaction(), tuple.pack(), tuple2.pack(), n);
    }

    private static CloseableAsyncIterator<KeyValue> listTenants_internal(Transaction transaction, byte[] byArray, byte[] byArray2, int n) {
        return new TenantAsyncIterator(transaction, byArray, byArray2, n);
    }

    private TenantManagement() {
    }

    static class TenantAsyncIterator
    implements CloseableAsyncIterator<KeyValue> {
        Transaction tr;
        final byte[] begin;
        final byte[] end;
        final AsyncIterable<KeyValue> firstGet;
        AsyncIterator<KeyValue> iter;
        private boolean closed;

        TenantAsyncIterator(Transaction transaction, byte[] byArray, byte[] byArray2, int n) {
            this.tr = transaction;
            this.begin = ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray);
            this.end = ByteArrayUtil.join(TENANT_MAP_PREFIX, byArray2);
            transaction.options().setRawAccess();
            transaction.options().setLockAware();
            this.firstGet = transaction.getRange(this.begin, this.end, n);
            this.iter = this.firstGet.iterator();
            this.closed = false;
        }

        @Override
        public CompletableFuture<Boolean> onHasNext() {
            return this.iter.onHasNext();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue next() {
            KeyValue keyValue = this.iter.next();
            byte[] byArray = Arrays.copyOfRange(keyValue.getKey(), TENANT_MAP_PREFIX.length, keyValue.getKey().length);
            byte[] byArray2 = keyValue.getValue();
            KeyValue keyValue2 = new KeyValue(byArray, byArray2);
            return keyValue2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Tenant lists are read-only");
        }

        @Override
        public void close() {
            this.tr.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            try {
                if (FDB.instance().warnOnUnclosed && !this.closed) {
                    System.err.println("CloseableAsyncIterator not closed (listTenants)");
                }
                if (!this.closed) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

