/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.Diff;

public class CommitsApi
extends AbstractApi {
    public CommitsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Commit> getCommits(int projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "commits");
        return (List)response.readEntity((GenericType)new GenericType<List<Commit>>(){});
    }

    public Commit getCommits(int projectId, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "commits", sha);
        return (Commit)response.readEntity(Commit.class);
    }

    public Diff getDiff(int projectId, String sha) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "repository", "commits", sha, "diff");
        return (Diff)response.readEntity(Diff.class);
    }
}

