/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.Visibility;

public class GroupApi
extends AbstractApi {
    public GroupApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Group> getGroups() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups");
        return (List)response.readEntity((GenericType)new GenericType<List<Group>>(){});
    }

    public List<Project> getProjects(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", groupId, "projects");
        return (List)response.readEntity((GenericType)new GenericType<List<Project>>(){});
    }

    public Group getGroup(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", groupId);
        return (Group)response.readEntity(Group.class);
    }

    public void addGroup(String name, String path) throws GitLabApiException {
        Form formData = new Form();
        formData.param("name", name);
        formData.param("path", path);
        this.post(Response.Status.CREATED, formData, "groups");
    }

    public void addGroup(String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        this.post(Response.Status.CREATED, (Form)formData, "groups");
    }

    public Group updateGroup(Integer groupId, String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Integer parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", groupId);
        return (Group)response.readEntity(Group.class);
    }

    public void deleteGroup(Integer groupId) throws GitLabApiException {
        if (groupId == null) {
            throw new RuntimeException("groupId cannot be null");
        }
        this.delete(Response.Status.OK, null, "groups", groupId);
    }

    public void deleteGroup(Group group) throws GitLabApiException {
        this.deleteGroup(group.getId());
    }

    public List<Member> getMembers(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", groupId, "members");
        return (List)response.readEntity((GenericType)new GenericType<List<Member>>(){});
    }

    public Member addMember(Integer groupId, Integer userId, Integer accessLevel) throws GitLabApiException {
        Form formData = new Form();
        formData.param("user_id", userId.toString());
        formData.param("access_level", accessLevel.toString());
        Response response = this.post(Response.Status.OK, formData, "groups", groupId, "members");
        return (Member)response.readEntity(Member.class);
    }

    public void removeMember(Integer projectId, Integer userId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "groups", projectId, "members", userId);
    }
}

