/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Project;

public class ServicesApi
extends AbstractApi {
    public ServicesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public void setGitLabCI(Integer projectId, String token, String projectCIUrl) throws GitLabApiException {
        Form formData = new Form();
        formData.param("token", token);
        formData.param("project_url", projectCIUrl);
        this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "services", "gitlab-ci");
    }

    public void setGitLabCI(Project project, String token, String projectCIUrl) throws GitLabApiException {
        this.setGitLabCI(project.getId(), token, projectCIUrl);
    }

    public void deleteGitLabCI(Integer projectId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", projectId, "services", "gitlab-ci");
    }

    public void deleteGitLabCI(Project project) throws GitLabApiException {
        this.deleteGitLabCI(project.getId());
    }

    public void setHipChat(Integer projectId, String token, String room, String server) throws GitLabApiException {
        Form formData = new Form();
        formData.param("token", token);
        formData.param("room", room);
        formData.param("server", server);
        this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "services", "hipchat");
    }

    public void setHipChat(Project project, String token, String room, String server) throws GitLabApiException {
        this.setHipChat(project.getId(), token, room, server);
    }

    public void deleteHipChat(Integer projectId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", projectId, "services", "hipchat");
    }

    public void deleteHipChat(Project project) throws GitLabApiException {
        this.deleteHipChat(project.getId());
    }
}

