/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Visibility {
    PUBLIC,
    PRIVATE,
    INTERNAL;

    private static Map<String, Visibility> valuesMap;

    @JsonCreator
    public static Visibility forValue(String value) {
        return valuesMap.get(value);
    }

    @JsonValue
    public String toValue() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    static {
        valuesMap = new HashMap<String, Visibility>(3);
        for (Visibility visibility : Visibility.values()) {
            valuesMap.put(visibility.toValue(), visibility);
        }
    }
}

