/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.tools.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.graalvm.python.embedding.tools.exec.SubprocessLog;

public class GraalPyRunner {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final String BIN_DIR = IS_WINDOWS ? "Scripts" : "bin";
    private static final String EXE_SUFFIX = IS_WINDOWS ? ".exe" : "";

    public static void run(Set<String> classpath, SubprocessLog log, String ... args) throws IOException, InterruptedException {
        String workdir = System.getProperty("exec.workingdir");
        Path java = Paths.get(System.getProperty("java.home"), "bin", "java");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java.toString());
        cmd.add("-classpath");
        cmd.add(String.join((CharSequence)File.pathSeparator, classpath));
        cmd.add("com.oracle.graal.python.shell.GraalPythonMain");
        cmd.addAll(List.of(args));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (workdir != null) {
            pb.directory(new File(workdir));
        }
        log.log(String.format("Running GraalPy: %s", String.join((CharSequence)" ", cmd)));
        GraalPyRunner.runProcess(pb, log);
    }

    public static void runLauncher(String launcherPath, SubprocessLog log, String ... args) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(launcherPath);
        cmd.addAll(List.of(args));
        log.log(String.format("Running: %s", String.join((CharSequence)" ", cmd)));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        GraalPyRunner.runProcess(pb, log);
    }

    public static void runPip(Path venvDirectory, String command, SubprocessLog log, String ... args) throws IOException, InterruptedException {
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add("-m");
        newArgs.add("pip");
        GraalPyRunner.addProxy(newArgs);
        newArgs.add(command);
        newArgs.addAll(List.of(args));
        GraalPyRunner.runVenvBin(venvDirectory, "graalpy", log, newArgs);
    }

    public static void runVenvBin(Path venvDirectory, String command, SubprocessLog log, String ... args) throws IOException, InterruptedException {
        GraalPyRunner.runVenvBin(venvDirectory, command, log, List.of(args));
    }

    private static void runVenvBin(Path venvDirectory, String command, SubprocessLog log, List<String> args) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(venvDirectory.resolve(BIN_DIR).resolve(command + EXE_SUFFIX).toString());
        cmd.addAll(args);
        log.log(String.join((CharSequence)" ", cmd));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        GraalPyRunner.runProcess(pb, log);
    }

    private static void addProxy(ArrayList<String> args) {
        if (System.getenv("http_proxy") == null && System.getenv("https_proxy") == null) {
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<Proxy> proxies = proxySelector.select(URI.create("https://pypi.org"));
            String proxyAddr = null;
            for (Proxy proxy : proxies) {
                if (proxy.type() != Proxy.Type.HTTP) continue;
                proxyAddr = GraalPyRunner.fixProtocol(proxy.address().toString(), "http");
                break;
            }
            if (proxyAddr != null) {
                args.add("--proxy");
                args.add(proxyAddr);
            }
        }
    }

    private static String fixProtocol(String proxyAddress, String protocol) {
        return proxyAddress.startsWith(protocol) ? proxyAddress : protocol + "://" + proxyAddress;
    }

    private static void runProcess(ProcessBuilder pb, SubprocessLog log) throws IOException, InterruptedException {
        pb.redirectError();
        pb.redirectOutput();
        Process process = pb.start();
        Thread outputReader = new Thread(() -> {
            try (InputStream is = process.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.subProcessOut(line);
                }
            }
            catch (IOException e) {
                log.log("exception while reading subprocess out", e);
            }
        });
        outputReader.start();
        Thread errorReader = new Thread(() -> {
            try {
                String line;
                BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = errorBufferedReader.readLine()) != null) {
                    log.subProcessErr(line);
                }
            }
            catch (IOException e) {
                log.log("exception while reading subprocess err", e);
            }
        });
        errorReader.start();
        process.waitFor();
        outputReader.join();
        errorReader.join();
        if (process.exitValue() != 0) {
            throw new RuntimeException(String.format("Running command: '%s' ended with code %d.See the error output above.", String.join((CharSequence)" ", pb.command()), process.exitValue()));
        }
    }
}

